/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.constants;

public enum TagClass {
    UNIVERSAL(0, "universal"),
    APPLICATION(1, "application"),
    CONTEXT_SPECIFIC(2, "context-specific"),
    PRIVATE(3, "private");

    private final int intValue;
    private final String stringValue;

    private TagClass(int intValue, String stringValue) {
        this.intValue = intValue;
        this.stringValue = stringValue;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public static TagClass fromIntValue(int intValue) {
        TagClass[] tagClassArray = TagClass.values();
        int n = tagClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            TagClass currentTagClass = tagClassArray[n2];
            if (currentTagClass.getIntValue() == intValue) {
                return currentTagClass;
            }
            ++n2;
        }
        return null;
    }

    public static TagClass fromStringValue(String stringValue) {
        TagClass[] tagClassArray = TagClass.values();
        int n = tagClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            TagClass currentTagClass = tagClassArray[n2];
            if (currentTagClass.getStringValue().equalsIgnoreCase(stringValue)) {
                return currentTagClass;
            }
            ++n2;
        }
        return null;
    }

    public static TagClass fromIdentifierByte(byte identifierByte) {
        return TagClass.fromIntValue(identifierByte >> 6 & 3);
    }
}

