/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.singlebyte;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.rub.nds.modifiablevariable.ModifiableVariable;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ModifiableByte
extends ModifiableVariable<Byte> {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Byte originalValue;

    public ModifiableByte() {
    }

    public ModifiableByte(Byte originalValue) {
        this.originalValue = originalValue;
    }

    public ModifiableByte(ModifiableByte other) {
        super(other);
        this.originalValue = other.originalValue;
    }

    public ModifiableByte createCopy() {
        return new ModifiableByte(this);
    }

    public Byte getAssertEquals() {
        return (Byte)this.assertEquals;
    }

    public void setAssertEquals(Byte assertEquals) {
        this.assertEquals = assertEquals;
    }

    @Override
    public boolean isOriginalValueModified() {
        if (this.originalValue == null) {
            throw new IllegalStateException("Original value must be set before modification");
        }
        return this.originalValue.compareTo((Byte)this.getValue()) != 0;
    }

    @Override
    public boolean validateAssertions() {
        boolean valid = true;
        if (this.assertEquals != null && ((Byte)this.assertEquals).compareTo((Byte)this.getValue()) != 0) {
            valid = false;
        }
        return valid;
    }

    @Override
    public Byte getOriginalValue() {
        return this.originalValue;
    }

    @Override
    public void setOriginalValue(Byte originalValue) {
        this.originalValue = originalValue;
    }

    public String toString() {
        return "ModifiableByte{originalValue=" + this.originalValue + this.innerToString() + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModifiableByte)) {
            return false;
        }
        ModifiableByte that = (ModifiableByte)obj;
        return this.getValue() != null ? ((Byte)this.getValue()).equals(that.getValue()) : that.getValue() == null;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.getValue() != null ? ((Byte)this.getValue()).hashCode() : 0);
        return result;
    }
}

