/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.singlebyte;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rub.nds.modifiablevariable.VariableModification;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Objects;

@XmlRootElement
public class ByteSubtractModification
extends VariableModification<Byte> {
    @JsonProperty(required=true)
    private byte subtrahend;

    private ByteSubtractModification() {
    }

    public ByteSubtractModification(byte subtrahend) {
        this.subtrahend = subtrahend;
    }

    public ByteSubtractModification(ByteSubtractModification other) {
        this.subtrahend = other.subtrahend;
    }

    public ByteSubtractModification createCopy() {
        return new ByteSubtractModification(this);
    }

    @Override
    protected Byte modifyImplementationHook(Byte input) {
        if (input == null) {
            return null;
        }
        return (byte)(input - this.subtrahend);
    }

    public byte getSubtrahend() {
        return this.subtrahend;
    }

    public void setSubtrahend(byte subtrahend) {
        this.subtrahend = subtrahend;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.subtrahend;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteSubtractModification other = (ByteSubtractModification)obj;
        return Objects.equals(this.subtrahend, other.subtrahend);
    }

    public String toString() {
        return "ByteSubtractModification{subtrahend=" + this.subtrahend + "}";
    }
}

