/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.json;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import de.rub.nds.modifiablevariable.json.ModifiableVariableModule;
import de.rub.nds.modifiablevariable.json.ReflectiveJacksonSchemaModule;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;

public class JsonSchemaCliGenerator {
    public static void main(String[] args) {
        ObjectNode jsonSchema;
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(ModifiableVariableModule.getFieldVisibilityChecker());
        for (int i = 2; i < args.length; ++i) {
            try {
                mapper.registerModule((Module)Class.forName(args[i]).getConstructor(new Class[0]).newInstance(new Object[0]));
                continue;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        SchemaGeneratorConfigBuilder builder = new SchemaGeneratorConfigBuilder(mapper, SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON);
        builder.with((com.github.victools.jsonschema.generator.Module)new ReflectiveJacksonSchemaModule());
        SchemaGeneratorConfig config = builder.build();
        SchemaGenerator generator = new SchemaGenerator(config);
        try {
            jsonSchema = generator.generateSchema(Class.forName(args[0]), new Type[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        File outputFile = new File(args[1]);
        assert (outputFile.exists() || outputFile.mkdirs());
        try {
            mapper.writerWithDefaultPrettyPrinter().writeValue(outputFile, (Object)jsonSchema);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write JSON schema to file: " + outputFile.getAbsolutePath(), e);
        }
    }
}

