/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.bytearray;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Arrays;
import java.util.Objects;

@XmlRootElement
public class ByteArrayExplicitValueModification
extends VariableModification<byte[]> {
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    @JsonProperty(required=true)
    private byte[] explicitValue;

    private ByteArrayExplicitValueModification() {
    }

    public ByteArrayExplicitValueModification(byte[] explicitValue) {
        this.explicitValue = Objects.requireNonNull(explicitValue, "ExplicitValue must not be null");
    }

    public ByteArrayExplicitValueModification(ByteArrayExplicitValueModification other) {
        this.explicitValue = (byte[])other.explicitValue.clone();
    }

    public ByteArrayExplicitValueModification createCopy() {
        return new ByteArrayExplicitValueModification(this);
    }

    @Override
    protected byte[] modifyImplementationHook(byte[] input) {
        if (input == null) {
            return null;
        }
        return (byte[])this.explicitValue.clone();
    }

    public byte[] getExplicitValue() {
        return this.explicitValue;
    }

    public void setExplicitValue(byte[] explicitValue) {
        this.explicitValue = Objects.requireNonNull(explicitValue, "ExplicitValue must not be null");
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Arrays.hashCode(this.explicitValue);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArrayExplicitValueModification other = (ByteArrayExplicitValueModification)obj;
        return Arrays.equals(this.explicitValue, other.explicitValue);
    }

    public String toString() {
        return "ByteArrayExplicitValueModification{explicitValue=" + DataConverter.bytesToHexString(this.explicitValue) + "}";
    }
}

