/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable;

import de.rub.nds.modifiablevariable.ModifiableVariable;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.modifiablevariable.util.ReflectionHelper;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlType(name="ModVarHolder")
public abstract class ModifiableVariableHolder
implements Serializable {
    private static final Logger LOGGER = LogManager.getLogger();

    protected ModifiableVariableHolder() {
    }

    public final List<Field> getAllModifiableVariableFields() {
        return ReflectionHelper.getFieldsUpTo(this.getClass(), null, ModifiableVariable.class);
    }

    public final Field getRandomModifiableVariableField(Random random) {
        List<Field> fields = this.getAllModifiableVariableFields();
        int randomField = random.nextInt(fields.size());
        return fields.get(randomField);
    }

    public List<ModifiableVariableHolder> getAllModifiableVariableHolders() {
        LinkedList<ModifiableVariableHolder> holders = new LinkedList<ModifiableVariableHolder>();
        holders.add(this);
        return holders;
    }

    public final ModifiableVariableHolder getRandomModifiableVariableHolder(Random random) {
        List<ModifiableVariableHolder> holders = this.getAllModifiableVariableHolders();
        int randomHolder = random.nextInt(holders.size());
        return holders.get(randomHolder);
    }

    public void reset() {
        List<Field> fields = this.getAllModifiableVariableFields();
        for (Field field : fields) {
            field.setAccessible(true);
            ModifiableVariable mv = null;
            try {
                mv = (ModifiableVariable)field.get(this);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                LOGGER.warn("Could not retrieve ModifiableVariables");
                LOGGER.debug((Object)ex);
            }
            if (mv == null) continue;
            if (mv.getModifications() != null) {
                mv.setOriginalValue(null);
                continue;
            }
            try {
                field.set(this, null);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                LOGGER.warn("Could not strip ModifiableVariable without Modification");
            }
        }
    }

    public String getExtendedString() {
        return this.getClass().getSimpleName() + "{\n" + this.getExtendedString(1) + "}\n";
    }

    protected String getExtendedString(int depth) {
        StringBuilder stringBuilder = new StringBuilder();
        List<Field> fields = ReflectionHelper.getFieldsUpTo(this.getClass(), null, null);
        for (Field field : fields) {
            field.setAccessible(true);
            if (Modifier.isStatic(field.getModifiers())) continue;
            Object tempObject = null;
            try {
                tempObject = field.get(this);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                LOGGER.warn("Could not retrieve ModifiableVariables");
                LOGGER.debug((Object)ex);
            }
            if (tempObject != null) {
                if (tempObject instanceof byte[]) {
                    byte[] temp = (byte[])tempObject;
                    stringBuilder.append("\t".repeat(Math.max(0, depth)));
                    stringBuilder.append(field.getName());
                    stringBuilder.append(": ");
                    stringBuilder.append(DataConverter.bytesToHexString(temp));
                    stringBuilder.append("\n");
                }
                if (tempObject instanceof ModifiableVariableHolder) {
                    stringBuilder.append("\t".repeat(Math.max(0, depth)));
                    stringBuilder.append(field.getName());
                    stringBuilder.append(":");
                    stringBuilder.append(tempObject.getClass().getSimpleName());
                    stringBuilder.append("{\n");
                    stringBuilder.append(((ModifiableVariableHolder)tempObject).getExtendedString(depth + 1));
                    stringBuilder.append("\t".repeat(Math.max(0, depth)));
                    stringBuilder.append("}\n");
                    continue;
                }
                stringBuilder.append("\t".repeat(Math.max(0, depth)));
                stringBuilder.append(field.getName());
                stringBuilder.append(": ");
                stringBuilder.append(tempObject);
                stringBuilder.append("\n");
                continue;
            }
            stringBuilder.append("\t".repeat(Math.max(0, depth)));
            stringBuilder.append(field.getName());
            stringBuilder.append(": null\n");
        }
        return stringBuilder.toString();
    }
}

