/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import de.rub.nds.modifiablevariable.VariableModification;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

@XmlTransient
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.SIMPLE_NAME, include=JsonTypeInfo.As.PROPERTY, property="@type")
public abstract class ModifiableVariable<E>
implements Serializable {
    @XmlElementWrapper
    @XmlAnyElement(lax=true)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private LinkedList<VariableModification<E>> modifications;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected E assertEquals;

    protected ModifiableVariable() {
    }

    protected ModifiableVariable(ModifiableVariable<E> other) {
        if (other.modifications != null) {
            this.modifications = new LinkedList();
            for (VariableModification variableModification : other.modifications) {
                this.modifications.add(variableModification != null ? variableModification.createCopy() : null);
            }
        }
        this.assertEquals = other.assertEquals;
    }

    public void setModifications(List<VariableModification<E>> modifications) {
        this.modifications = new LinkedList<VariableModification<VariableModification<E>>>(modifications);
    }

    @SafeVarargs
    public final void setModifications(VariableModification<E> ... modifications) {
        this.modifications = new LinkedList<VariableModification<VariableModification<E>>>(List.of(modifications));
    }

    public void clearModifications() {
        this.modifications = null;
    }

    public void addModification(VariableModification<E> modification) {
        if (modification != null) {
            if (this.modifications == null) {
                this.modifications = new LinkedList();
            }
            this.modifications.add(modification);
        }
    }

    public LinkedList<VariableModification<E>> getModifications() {
        return this.modifications;
    }

    public E getValue() {
        return this.getModifiedValue();
    }

    private E getModifiedValue() {
        E resultValue = this.getOriginalValue();
        if (this.modifications != null) {
            for (VariableModification variableModification : this.modifications) {
                resultValue = variableModification.modify(resultValue);
            }
        }
        return resultValue;
    }

    public abstract E getOriginalValue();

    public abstract void setOriginalValue(E var1);

    public abstract ModifiableVariable<E> createCopy();

    public abstract boolean isOriginalValueModified();

    public abstract boolean validateAssertions();

    public boolean containsAssertion() {
        return this.assertEquals != null;
    }

    protected String innerToString() {
        StringBuilder result = new StringBuilder();
        if (this.modifications != null) {
            result.append(", modifications=[").append(this.modifications.stream().map(Object::toString).collect(Collectors.joining(", "))).append("]");
        }
        if (this.assertEquals != null) {
            result.append(", assertEquals=").append(this.assertEquals);
        }
        return result.toString();
    }
}

