# 
# TAOF, the general purpose TCP fuzzer.
# Copyright (C) 2007 Rodrigo Marcos
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
# 

import xml.dom.minidom # for xml input/output
import fuzzutils

####################################
class xmlsettings:

#TO DO:
# Check the physical path when reading and writing to settings.xml

	def __init__(self):
		self.file = fuzzutils.context["TAOF_PATH"] + "settings.xml"

	def create_document(self,timeout, wait, wait_reconnection, dictionary):
		doc=xml.dom.minidom.Document()
		settings_element = doc.createElementNS("", "taof_settings")
		settings_element.setAttributeNS("","timeout", timeout)
		settings_element.setAttributeNS("","wait", wait)
		settings_element.setAttributeNS("","wait_reconnection", wait_reconnection)
		settings_element.setAttributeNS("","dictionary", dictionary)
		doc.appendChild(settings_element)
#write to file
		file_object = open(self.file, "w")
		doc.writexml(file_object)
		file_object.close()

	
	def get_document(self):
		try:
			doc = xml.dom.minidom.parse(self.file)
		except:
			#create document with default settings
			self.create_document('3','0.2','0.5','')# timeout, wait, wait_reconnection, dictionary
			doc = xml.dom.minidom.parse(self.file)
		taof_settings = doc.getElementsByTagName("taof_settings")
		return float(taof_settings[0].attributes["timeout"].value), float(taof_settings[0].attributes["wait"].value), float(taof_settings[0].attributes["wait_reconnection"].value), taof_settings[0].attributes["dictionary"].value
	
	def get_settings(self):
		fuzzutils.context["timeout"], fuzzutils.context["wait"], fuzzutils.context["wait_reconnection"], fuzzutils.context["dictionary"] = self.get_document()
 # timeout - (seconds) timeout for receiving response from server
 # wait - (seconds) waiting time between requests 
 # wait_reconnection - (seconds) waiting time between reconections 

