/*
 * Decompiled with CFR 0.152.
 */
package stigviewer;

import Utility_Code.GlobalSettings.Util;
import Utility_Code.Static_Methods.ErrorHandlers;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class SavePoint {
    private String ev_UserHome;
    private String ev_UserLocal;
    private static final String csLocalDataFolderName = "STIGV_AppData";
    private static final String csConfigFileName = "Config.cnf";
    private boolean bLockSavepoint = false;
    private boolean bHasConfigFolder;
    private File fSTIGFolder;
    private File tempFile;
    private File fSPLocation;

    public SavePoint() throws IOException {
        this.SetupSavePoint();
    }

    private void SetupSavePoint() {
        block6: {
            try {
                this.ev_UserHome = System.getProperty("user.home");
                this.ev_UserLocal = System.getenv("LOCALAPPDATA");
                if (!Util.bHasAlphNum(this.ev_UserLocal)) {
                    this.ev_UserLocal = System.getenv("APPDATA");
                    Util.SetSlashWindows();
                }
                if (!Util.bHasAlphNum(this.ev_UserLocal) && Util.bHasAlphNum(this.ev_UserHome)) {
                    this.ev_UserLocal = this.ev_UserHome;
                    Util.SetSlashUNIX();
                }
                if (!Util.bHasAlphNum(this.ev_UserLocal)) {
                    this.bLockSavepoint = true;
                }
                if (!this.bLockSavepoint) {
                    this.fSPLocation = new File(this.ev_UserLocal + Util.GetSlash() + csLocalDataFolderName);
                    this.fSTIGFolder = new File(this.fSPLocation.getPath() + Util.GetSlash() + "STIGs");
                    this.tempFile = new File(this.fSPLocation.getPath() + Util.GetSlash() + "tmp");
                }
            }
            catch (Exception e) {
                ErrorHandlers.saveFileError();
                if (!Util.bAllowPrintln) break block6;
                e.printStackTrace();
            }
        }
    }

    public void CreateSavePoint() {
        block4: {
            String Slash = Util.GetSlash();
            File Test = new File(this.ev_UserLocal + Slash + csLocalDataFolderName + Slash + csConfigFileName);
            try {
                File baseDir = new File(this.ev_UserLocal + Slash + csLocalDataFolderName);
                File STIGDir = new File(this.ev_UserLocal + Slash + csLocalDataFolderName + Slash + "STIGs");
                if (!baseDir.exists()) {
                    baseDir.mkdir();
                }
                if (!STIGDir.exists()) {
                    STIGDir.mkdir();
                }
                Test.createNewFile();
                this.bHasConfigFolder = true;
            }
            catch (Exception ex) {
                ErrorHandlers.saveFileError();
                if (!Util.bAllowPrintln) break block4;
                ex.printStackTrace();
            }
        }
    }

    public void DeleteSavePoint() {
        block6: {
            if (this.bHasConfigFolder) {
                try {
                    int iAns = 0;
                    switch (iAns) {
                        case 0: {
                            File fToDelete = new File(this.ev_UserLocal + Util.GetSlash() + csLocalDataFolderName);
                            if (!Util.RecursiveDelete(fToDelete)) break;
                            this.bHasConfigFolder = false;
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    if (!Util.bAllowPrintln) break block6;
                    e.printStackTrace();
                }
            }
        }
    }

    public void WriteSTIGToSave(byte[] bOut, String sName) {
        block3: {
            File fOutput = new File(this.fSTIGFolder.getPath() + Util.GetSlash() + sName);
            if (!fOutput.exists()) {
                try {
                    FileOutputStream fOut = new FileOutputStream(fOutput);
                    fOut.write(bOut);
                }
                catch (IOException e) {
                    ErrorHandlers.saveFileError();
                    if (!Util.bAllowPrintln) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    public File WriteSTIGToSave(InputStream IS, String sName) {
        File fOutput;
        block6: {
            fOutput = new File(this.fSTIGFolder.getPath() + Util.GetSlash() + sName);
            if (!fOutput.exists()) {
                try {
                    BufferedInputStream BIS = new BufferedInputStream(IS);
                    FileOutputStream fOut = new FileOutputStream(fOutput);
                    byte[] bTemp = new byte[BIS.available()];
                    BIS.read(bTemp);
                    fOut.write(bTemp);
                    fOut.close();
                    IS.close();
                }
                catch (Exception e) {
                    block5: {
                        ErrorHandlers.saveFileError();
                        try {
                            IS.close();
                        }
                        catch (IOException ex) {
                            if (!Util.bAllowPrintln) break block5;
                            ex.printStackTrace();
                        }
                    }
                    if (!Util.bAllowPrintln) break block6;
                    e.printStackTrace();
                }
            }
        }
        return fOutput;
    }

    public boolean HasConfigFolder() {
        return this.bHasConfigFolder;
    }

    public String GetSavePointLocation() {
        return this.fSPLocation + Util.GetSlash();
    }

    public File GetSTIGFolder() {
        return this.fSTIGFolder;
    }

    public File getTempFolder() {
        return this.tempFile;
    }

    public void SetSavePointLocation(String Path2) {
    }
}

