/*
 * Decompiled with CFR 0.152.
 */
package Shared_Constructs.STIGList;

import File_Operations.File_Objects.STIG;
import Program_Tabs.interfaces.STIGDisplayTab;
import Shared_Constructs.STIGList.STIGTableItem;
import Utility_Code.GlobalSettings.DisplayObject;
import Utility_Code.GlobalSettings.Preferences_Window.PrefSet;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Paint;
import javafx.util.Callback;

public abstract class StigList_Abstract
extends DisplayObject {
    protected STIGDisplayTab myParent;
    protected ArrayList<STIGDispColumn> myDispSet;
    protected ObservableList<STIGTableItem> data;
    protected ObservableList<TableColumn> columns;
    protected ObservableList<TablePosition> selectedCells;
    protected STIGTableItem StigTableItem;
    protected TableView myTable;
    protected TableColumn STIGNameColumn;
    protected TableColumn ScoreColumn;
    protected TableColumn STIGFileNameColumn;
    protected TableColumn CustomNameColumn;
    protected TableColumn STIGVersionColumn;
    protected TableColumn STIGCheckColumn;
    protected TableColumn STIGReleaseIDColumn;

    public StigList_Abstract(STIGDisplayTab Parent2, ArrayList<STIGDispColumn> ColumnSet) {
        this.myParent = Parent2;
        this.myDispSet = ColumnSet;
        this.myTable = new TableView();
        this.myTable.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.STIGNameColumn = new TableColumn("Name");
        this.ScoreColumn = new TableColumn("Score");
        this.STIGFileNameColumn = new TableColumn("FileName");
        this.CustomNameColumn = new TableColumn("Name");
        this.STIGVersionColumn = new TableColumn("Version");
        this.STIGCheckColumn = new TableColumn("CK");
        this.STIGReleaseIDColumn = new TableColumn("Release Number");
        this.myTable.setStyle(PrefSet.getPS().getJfxBackground());
    }

    public abstract TableView createTable();

    public abstract void changeSTIGList(ArrayList<STIG> var1);

    protected void createSTIGReleaseIDColumn() {
        this.STIGReleaseIDColumn.setEditable(false);
        this.STIGReleaseIDColumn.setResizable(true);
        this.STIGReleaseIDColumn.setEditable(false);
        this.STIGReleaseIDColumn.setCellFactory(this.getSLCellFactory());
    }

    protected void createSTIGNameColumn() {
        this.STIGNameColumn.setEditable(false);
        this.STIGNameColumn.setResizable(true);
        this.STIGNameColumn.setEditable(false);
        this.STIGNameColumn.setCellFactory(this.getSLCellFactory());
    }

    protected void createScoreColumn() {
        this.ScoreColumn.setEditable(false);
        this.ScoreColumn.setResizable(true);
        this.ScoreColumn.setMinWidth(100.0);
        this.ScoreColumn.setEditable(false);
        this.ScoreColumn.setCellFactory(this.getSLCellFactory());
    }

    protected void createSTIGFileNameColumn() {
        this.STIGFileNameColumn.setEditable(false);
        this.STIGFileNameColumn.setResizable(true);
        this.STIGFileNameColumn.setEditable(false);
        this.STIGFileNameColumn.setCellFactory(this.getSLCellFactory());
    }

    protected void createCustomNameColumn() {
        this.CustomNameColumn.setEditable(false);
        this.CustomNameColumn.setResizable(true);
        this.CustomNameColumn.setEditable(false);
    }

    protected void createSTIGVersionColumn() {
        this.STIGVersionColumn.setEditable(false);
        this.STIGVersionColumn.setResizable(true);
        this.STIGVersionColumn.setEditable(false);
        this.STIGVersionColumn.setCellFactory(this.getSLCellFactory());
    }

    protected void createSTIGCheckColumn() {
        this.STIGCheckColumn.setEditable(false);
        this.STIGCheckColumn.setResizable(false);
        this.STIGCheckColumn.setPrefWidth(32.0);
        this.STIGCheckColumn.setCellValueFactory((Callback)new PropertyValueFactory("STIGCheck"));
        this.STIGCheckColumn.setCellFactory(CheckBoxTableCell.forTableColumn((TableColumn)this.STIGCheckColumn));
        this.STIGCheckColumn.setEditable(false);
    }

    protected void handleCheckChange() {
    }

    protected Callback<TableView, TableRow> getSLRowFactory() {
        return new Callback<TableView, TableRow>(){

            public TableRow call(TableView p) {
                final TableRow row = new TableRow();
                row.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        if (event.getButton().equals((Object)MouseButton.PRIMARY) && !event.isShiftDown() && !event.isControlDown()) {
                            if (!row.isEmpty()) {
                                boolean checkTrigger = ((STIGTableItem)row.getItem()).bGetIsChecked();
                                ((STIGTableItem)row.getItem()).setIsChecked(!checkTrigger);
                                StigList_Abstract.this.signalStigListUpdate();
                                Logger.getLogger(StigList_Abstract.class.getName()).log(Level.INFO, "INFO: SL: Stig Checked " + ((STIGTableItem)row.getItem()).getSTIGName());
                            } else {
                                StigList_Abstract.this.myTable.getSelectionModel().clearSelection();
                            }
                        }
                    }
                });
                row.setStyle(PrefSet.getPS().getJfxTableDefault());
                row.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> ov, Boolean old, Boolean rec) {
                        if (rec.booleanValue()) {
                            row.setStyle(PrefSet.getPS().getJfxTableHighlight());
                        } else {
                            row.setStyle(PrefSet.getPS().getJfxTableDefault());
                        }
                    }
                });
                return row;
            }
        };
    }

    protected Callback<TableColumn<STIGTableItem, String>, TableCell<STIGTableItem, String>> getSLCellFactory() {
        return new Callback<TableColumn<STIGTableItem, String>, TableCell<STIGTableItem, String>>(){

            public TableCell<STIGTableItem, String> call(TableColumn p) {
                TableCell<STIGTableItem, String> tc = new TableCell<STIGTableItem, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(item == null || empty ? null : item.toString());
                        this.setGraphic(null);
                    }
                };
                tc.setStyle(PrefSet.getPS().getJfxFontSpec());
                tc.setTextFill((Paint)PrefSet.getPS().getSV_FONT_DEFAULT_COLOR());
                return tc;
            }
        };
    }

    protected void signalStigListUpdate() {
        ArrayList<STIG> STIGs = new ArrayList<STIG>();
        if (this.myTable.getItems() != null) {
            for (STIGTableItem row : this.myTable.getItems()) {
                if (!row.bGetIsChecked()) continue;
                STIGs.add(row.getSTIG());
            }
        }
        this.myParent.changeCurrentSTIG(STIGs);
    }

    private void signalStigListGChange() {
        ArrayList<STIG> STIGs = new ArrayList<STIG>();
        if (this.myTable.getItems() != null) {
            for (STIGTableItem row : this.myTable.getItems()) {
                if (!row.bGetIsChecked()) continue;
                STIGs.add(row.getSTIG());
            }
        }
        this.myParent.changeCurrentSTIG(STIGs);
    }

    @Override
    public List<DisplayObject> getChildDisplayObjects() {
        ArrayList<DisplayObject> dispOs = new ArrayList<DisplayObject>();
        return dispOs;
    }

    @Override
    public void graphicsUpdate() {
        this.signalStigListGChange();
        this.STIGReleaseIDColumn.setCellFactory(this.getSLCellFactory());
        this.STIGNameColumn.setCellFactory(this.getSLCellFactory());
        this.ScoreColumn.setCellFactory(this.getSLCellFactory());
        this.STIGFileNameColumn.setCellFactory(this.getSLCellFactory());
        this.STIGFileNameColumn.setCellFactory(this.getSLCellFactory());
        this.STIGCheckColumn.setCellFactory(CheckBoxTableCell.forTableColumn((TableColumn)this.STIGCheckColumn));
        this.myTable.setRowFactory(this.getSLRowFactory());
        this.myTable.setStyle(PrefSet.getPS().getJfxBackground());
    }

    public static enum STIGDispColumn {
        STIGName,
        Score,
        STIGFileName,
        CustomName,
        STIGVersion,
        Check,
        ReleaseID;

    }
}

