/*
 * Decompiled with CFR 0.152.
 */
package Shared_Constructs.Rule_Display;

import File_Operations.File_Objects.Vuln;
import File_Operations.Legacy.File_Interfaces.CCIReader;
import Program_Tabs.Tab_Checklist.ChecklistDriver;
import Program_Tabs.Tab_Checklist.ChecklistViewTab;
import Program_Tabs.Tab_Checklist.Checklist_Ctrl;
import Shared_Constructs.Rule_Display.Checklist_Rule_Display;
import Utility_Code.Static_Methods.TextReplace;
import java.util.LinkedHashMap;
import javafx.event.EventHandler;

public class Checklist_Rule_Display_Controller
extends Checklist_Ctrl {
    private Checklist_Rule_Display RDisplay;

    public Checklist_Rule_Display_Controller(ChecklistViewTab cvt, ChecklistDriver cdrive, Checklist_Rule_Display rdisplay) {
        super(cvt, cdrive);
        this.RDisplay = rdisplay;
    }

    @Override
    public void Signal_Update(String code) {
        Vuln v = this.DisplayDriver.getCurrentSelectedVuln();
        switch (code) {
            case "fdetail": {
                v.setCHK_Notes(this.RDisplay.getFDetailAreaText());
                break;
            }
            case "comment": {
                v.setCheckComment(this.RDisplay.getCommentAreaText());
                break;
            }
            case "status": {
                for (Vuln sv : this.DisplayDriver.getCurrentVulns()) {
                    sv.setCheckState(Vuln.CheckState.fromInt(this.RDisplay.getSelectedStatus()));
                }
                this.DisplayDriver.updateScoreMap();
                this.DisplayTab.updateSTIGTabGUI();
                this.DisplayTab.refreshTotals();
                this.DisplayTab.getVulnTable().UpdateDisplay();
                this.RDisplay.changeBodyBorder();
                break;
            }
            case "c": {
                this.textAreaChange();
                this.headingChange();
                this.titleChange();
                this.bodyChange();
                this.DisplayTab.getVulnTable().UpdateDisplay();
                break;
            }
            case "severity": {
                String osev = TextReplace.getSevFromCat(this.RDisplay.getSelectedSeverity());
                this.RDisplay.clearSevJust();
                if (v.getCheckSevOverride().equals("")) {
                    if (!osev.equals(v.getAttr(Vuln.VulnAttr.Severity))) {
                        this.determineSeverity();
                    }
                } else if (!osev.equals(v.getCheckSevOverride())) {
                    this.determineSeverity();
                }
                this.severityChange();
                this.DisplayTab.getVulnTable().UpdateDisplay();
                break;
            }
        }
    }

    private void headingChange() {
        this.statusChange();
        this.severityChange();
    }

    private void statusChange() {
        String st;
        Vuln v = this.DisplayDriver.getCurrentSelectedVuln();
        switch (st = v.getCheckState().toString()) {
            case "NR": {
                st = "Not Reviewed";
                break;
            }
            case "NF": {
                st = "Not A Finding";
                break;
            }
            case "O": {
                st = "Open";
                break;
            }
            case "NA": {
                st = "Not Applicable";
                break;
            }
        }
        EventHandler tmpEH = this.RDisplay.remStatusEH();
        this.RDisplay.setStatus(st);
        this.RDisplay.addStatusEH(tmpEH);
        this.RDisplay.changeBodyBorder();
    }

    private void severityChange() {
        Vuln v = this.DisplayDriver.getCurrentSelectedVuln();
        String sev = "";
        sev = !v.getCheckSevOverride().equals("") ? v.getCheckSevOverride() : v.getAttr(Vuln.VulnAttr.Severity);
        sev = TextReplace.getCatFromSev(sev);
        this.RDisplay.setSeverity(sev);
    }

    private void titleChange() {
        Vuln v = this.DisplayDriver.getCurrentSelectedVuln();
        LinkedHashMap<String, String> meta = new LinkedHashMap<String, String>();
        meta.put("Vul ID", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Vuln_Num), this.DisplayTab.getFilterPane().getFilterText("VulnID")));
        meta.put("Rule ID", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Rule_ID), this.DisplayTab.getFilterPane().getFilterText("RuleID")));
        meta.put("STIG ID", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Rule_Ver), this.DisplayTab.getFilterPane().getFilterText("STIGID")));
        meta.put("Severity", TextReplace.HTMLForm(TextReplace.getCatFromSev(v.getAttr(Vuln.VulnAttr.Severity)), this.DisplayTab.getFilterPane().getFilterText("Severity")));
        if (!v.getAttr(Vuln.VulnAttr.Check_Content_Ref).equals("M")) {
            meta.put("Check Reference", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Check_Content_Ref), this.DisplayTab.getFilterPane().getFilterText("General")));
        }
        meta.put("Classification", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Class), this.DisplayTab.getFilterPane().getFilterText("General")));
        this.RDisplay.changeTitleText(v.getAttr(Vuln.VulnAttr.STIGRef), meta);
    }

    private void bodyChange() {
        Vuln v = this.DisplayDriver.getCurrentSelectedVuln();
        LinkedHashMap<Object, String> rd = new LinkedHashMap<Object, String>();
        rd.put("Rule Title", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Rule_Title), this.DisplayTab.getFilterPane().getFilterText("RuleTitle")));
        rd.put("Discussion", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Vuln_Discuss), this.DisplayTab.getFilterPane().getFilterText("Discussion")));
        rd.put("Check Text", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Check_Content), this.DisplayTab.getFilterPane().getFilterText("CheckContent")));
        rd.put("Fix Text", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Fix_Text), this.DisplayTab.getFilterPane().getFilterText("FixText")));
        LinkedHashMap<String, String> ref = new LinkedHashMap<String, String>();
        String ccis = new String();
        for (CCIReader.CCI_Store c : v.GetCCIs()) {
            ccis = ccis + "\n" + c.sID + ": " + c.sDefinition + "\n";
            for (int i = 0; i < c.sRefs.size(); ++i) {
                ccis = ccis + c.sRefs.get(i).getFirst() + " :: " + c.sRefs.get(i).getSecond() + "\n";
            }
        }
        ref.put("CCI", TextReplace.HTMLForm(ccis, this.DisplayTab.getFilterPane().getFilterText("CCIText")));
        LinkedHashMap<String, String> misc = new LinkedHashMap<String, String>();
        misc.put("Severity Override Guidance", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Security_Override_Guidance), this.DisplayTab.getFilterPane().getFilterText("General")));
        misc.put("IA Controls", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.IA_Controls), this.DisplayTab.getFilterPane().getFilterText("MiscText")));
        misc.put("False Positives", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.False_Positives), this.DisplayTab.getFilterPane().getFilterText("General")));
        misc.put("False Positives", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.False_Negatives), this.DisplayTab.getFilterPane().getFilterText("General")));
        misc.put("Mitigations", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Mitigations), this.DisplayTab.getFilterPane().getFilterText("General")));
        misc.put("Potential Impact", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Potential_Impact), this.DisplayTab.getFilterPane().getFilterText("General")));
        misc.put("Third Party Tools", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Third_Party_Tools), this.DisplayTab.getFilterPane().getFilterText("General")));
        misc.put("Mitigation Control", TextReplace.HTMLForm(v.getAttr(Vuln.VulnAttr.Mitigation_Control), this.DisplayTab.getFilterPane().getFilterText("General")));
        this.RDisplay.changeBodyText(rd, ref, misc);
    }

    private void textAreaChange() {
        Vuln v = this.DisplayDriver.getCurrentSelectedVuln();
        this.RDisplay.setComBox(v.getCheckComment());
        this.RDisplay.setFDBox(v.getCHK_Notes());
    }

    private void determineSeverity() {
        Vuln v = this.DisplayDriver.getCurrentSelectedVuln();
        this.RDisplay.getsetSevOverJust(this.RDisplay.getSelectedSeverity());
        String jus = this.RDisplay.getSevJust();
        if (!jus.equals("")) {
            v.setCheckSevOverride(TextReplace.getSevFromCat(this.RDisplay.getSelectedSeverity()));
            v.setCheckSevJust(jus);
            this.DisplayTab.changeVulnList(this.DisplayDriver.UpdateVisibleListBySeverity(this.DisplayTab.getSevTab()));
        }
    }
}

