/*
 * Decompiled with CFR 0.152.
 */
package Program_Tabs.Tab_STIG;

import Program_Tabs.Tab_STIG.STIGDriver;
import Program_Tabs.Tab_STIG.STIGViewTab;
import Program_Tabs.interfaces.Controller;
import Shared_Constructs.Rule_Display.STIGs_Rule_Display_Controller;
import Utility_Code.GlobalSettings.DisplayObject;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import stigviewer.STIGViewer;

public class STIGsControllerSetup {
    private ArrayList<Controller> Controllers;
    private STIGDriver STIGDrive;
    private STIGViewTab STIGVTab;

    public STIGsControllerSetup() {
        try {
            this.STIGDrive = new STIGDriver(STIGViewer.getSV());
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(STIGsControllerSetup.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.STIGVTab = new STIGViewTab(STIGViewer.getSV(), this.STIGDrive);
        this.STIGDrive.setSTIGViewTab(this.STIGVTab);
        this.STIGDrive.loadSTIGsFromCache();
        this.STIGVTab.changeCurrentSTIG(null);
        STIGViewer.getSV().OpenNewTab(this.STIGDrive);
        this.Controllers = new ArrayList();
        this.Controllers.add(new STIGs_Rule_Display_Controller(this.STIGVTab, this.STIGDrive, this.STIGVTab.getRDisplay()));
        for (DisplayObject dos : this.STIGVTab.getChildDisplayObjects()) {
            dos.tieControllers(this.getControllers(dos.getClass().getSimpleName()));
        }
    }

    private ArrayList<Controller> getControllers(String code) {
        ArrayList<Controller> c = new ArrayList<Controller>();
        switch (code) {
            case "STIGs_Rule_Display": {
                c.add(this.Controllers.get(0));
                break;
            }
            case "VulnTable": {
                c.add(this.Controllers.get(0));
                break;
            }
        }
        return c;
    }

    public void SDUpdateGraphics() {
        this.STIGDrive.updateGraphics();
    }
}

