/*
 * Decompiled with CFR 0.152.
 */
package Program_Tabs.Tab_Checklist;

import File_Operations.File_Writers.CMRS_Writer;
import File_Operations.Legacy.Export_Functions.CSV_Writer;
import Program_Tabs.Tab_Checklist.ChecklistDriver;
import Program_Tabs.Tab_Checklist.CklCompare.ChecklistCompare;
import Shared_Constructs.ListSelectionDialog;
import Utility_Code.CustomExceptions.NoFileSelected;
import Utility_Code.GlobalSettings.Preferences_Window.PreferencesWindow;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import stigviewer.CommonMenuBar;
import stigviewer.STIGViewer;

public class ChecklistMenuBar
implements CommonMenuBar {
    private MenuBar ChecklistMenuBar;
    private static STIGViewer stigviewer;
    private ChecklistDriver ChecklistDriverParent;
    private File CurrentSaveFile;
    private String currentFileDirectory;
    private String CurrentMenuBarValue;
    private ChecklistCompare CklCmp;
    private MenuItem OptionsSettings;
    private MenuItem FileSaveChecklist;

    public String getCurrentMenuBarValue() {
        return this.CurrentMenuBarValue;
    }

    public void setCurrentMenuBarValue(String val) {
        this.CurrentMenuBarValue = val;
    }

    public ChecklistMenuBar(ChecklistDriver p) {
        this.ChecklistMenuBarInit(p);
        this.CurrentSaveFile = null;
    }

    public ChecklistMenuBar(ChecklistDriver p, File filePath) {
        this.ChecklistMenuBarInit(p);
        this.CurrentSaveFile = filePath;
        this.currentFileDirectory = filePath.getParent();
    }

    private void ChecklistMenuBarInit(ChecklistDriver p) {
        this.ChecklistMenuBar = this.createMenuBar();
        stigviewer = STIGViewer.getSV();
        this.ChecklistDriverParent = p;
        this.currentFileDirectory = "";
        this.CurrentMenuBarValue = "";
        this.CklCmp = new ChecklistCompare(p);
    }

    private MenuBar createMenuBar() {
        this.FileSaveChecklist = new MenuItem("Save Checklist");
        this.FileSaveChecklist.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Logger.getLogger(ChecklistMenuBar.class.getName()).log(Level.INFO, "Checklist Save option selected");
                if (ChecklistMenuBar.this.CurrentSaveFile == null) {
                    try {
                        ChecklistMenuBar.this.CurrentSaveFile = ChecklistMenuBar.this.ExportToSaveFormat();
                        ChecklistMenuBar.this.ChecklistDriverParent.setCurrentFilePath(ChecklistMenuBar.this.CurrentSaveFile);
                        ChecklistMenuBar.this.ChecklistDriverParent.getChecklistViewTab().getVulnTable().setStatusMessage("Checklist saved.");
                    }
                    catch (NoFileSelected ex) {
                        Logger.getLogger(ChecklistMenuBar.class.getName()).log(Level.CONFIG, "'Cancel' or 'X' Selected in FileChooser");
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ChecklistMenuBar.class.getName()).log(Level.SEVERE, "IO Error when saving checklist using 'Save' option");
                    }
                } else {
                    try {
                        ChecklistMenuBar.this.ChecklistDriverParent.SaveToCklFile(ChecklistMenuBar.this.CurrentSaveFile);
                        ChecklistMenuBar.this.ChecklistDriverParent.getChecklistViewTab().getVulnTable().setStatusMessage("Checklist saved.");
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ChecklistMenuBar.class.getName()).log(Level.SEVERE, "IO Error when saving checklist using 'Save' option");
                    }
                }
            }
        });
        MenuItem FileSaveAsChecklist = new MenuItem("Save Checklist As..");
        FileSaveAsChecklist.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Logger.getLogger(ChecklistMenuBar.class.getName()).log(Level.INFO, "Checklist Save As option selected");
                try {
                    ChecklistMenuBar.this.CurrentSaveFile = ChecklistMenuBar.this.ExportToSaveFormat();
                    ChecklistMenuBar.this.ChecklistDriverParent.setCurrentFilePath(ChecklistMenuBar.this.CurrentSaveFile);
                    ChecklistMenuBar.this.ChecklistDriverParent.getChecklistViewTab().getVulnTable().setStatusMessage("Checklist saved.");
                }
                catch (NoFileSelected ex) {
                    Logger.getLogger(ChecklistMenuBar.class.getName()).log(Level.CONFIG, "'Cancel' or 'X' Selected in FileChooser");
                }
                catch (IOException ex) {
                    Logger.getLogger(ChecklistMenuBar.class.getName()).log(Level.SEVERE, "IO Error when saving checklist using 'Save As' option.");
                }
            }
        });
        Menu FileMenu = new Menu("File");
        FileMenu.getItems().addAll((Object[])new MenuItem[]{this.FileSaveChecklist, FileSaveAsChecklist});
        Menu ImportMenu = new Menu("Import");
        MenuItem ImportXCCDFResults = new MenuItem("XCCDF Results File");
        ImportXCCDFResults.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Logger.getLogger(ChecklistMenuBar.class.getName()).log(Level.INFO, "Checklist Import Results option selected");
                ChecklistMenuBar.this.ImportXCCDFData();
            }
        });
        MenuItem ImportCklData = new MenuItem("Checklist Data");
        ImportCklData.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                Logger.getLogger(ChecklistMenuBar.class.getName()).log(Level.INFO, "Checklist Import Checklist Data option selected");
                try {
                    ChecklistMenuBar.this.ChecklistCompareSelection();
                    ChecklistMenuBar.this.CklCmp.process();
                    ChecklistMenuBar.this.ChecklistDriverParent.signalUpdate();
                }
                catch (NoFileSelected ex) {
                    Logger.getLogger(ChecklistMenuBar.class.getName()).log(Level.SEVERE, "'Cancel' or 'X' Selected in FileChooser");
                }
            }
        });
        ImportMenu.getItems().addAll((Object[])new MenuItem[]{ImportXCCDFResults, ImportCklData});
        Menu ExportMenu = new Menu("Export");
        MenuItem ExportCMRSFormat = new MenuItem("Gen. CMRS Import File");
        ExportCMRSFormat.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Logger.getLogger(ChecklistMenuBar.class.getName()).log(Level.INFO, "Checklist Export CMRS option selected");
                try {
                    ChecklistMenuBar.this.ExportToCMRSFormat();
                }
                catch (NoFileSelected ex) {
                    Logger.getLogger(ChecklistMenuBar.class.getName()).log(Level.CONFIG, "'Cancel' or 'X' Selected in FileChooser");
                }
            }
        });
        MenuItem ExportCSVFormat = new MenuItem("Data Export (.csv)");
        ExportCSVFormat.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Logger.getLogger(ChecklistMenuBar.class.getName()).log(Level.INFO, "Checklist Export .csv option selected");
                try {
                    ChecklistMenuBar.this.ExportToCSVFormat();
                }
                catch (NoFileSelected ex) {
                    Logger.getLogger(ChecklistMenuBar.class.getName()).log(Level.CONFIG, "'Cancel' or 'X' Selected in FileChooser");
                }
                catch (IOException ex) {
                    Logger.getLogger(ChecklistMenuBar.class.getName()).log(Level.SEVERE, "IO Error when attempting to export a Checklist as a .CSV file");
                }
            }
        });
        this.OptionsSettings = new MenuItem("Preferences");
        this.OptionsSettings.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                PreferencesWindow.getPreferencesWindow().Open();
            }
        });
        Menu OptionsMenu = new Menu("Options");
        OptionsMenu.getItems().add((Object)this.OptionsSettings);
        ExportMenu.getItems().addAll((Object[])new MenuItem[]{ExportCMRSFormat, ExportCSVFormat});
        MenuBar DefaultMenu = new MenuBar();
        DefaultMenu.getMenus().add((Object)FileMenu);
        DefaultMenu.getMenus().add((Object)ImportMenu);
        DefaultMenu.getMenus().add((Object)ExportMenu);
        DefaultMenu.getMenus().add((Object)OptionsMenu);
        return DefaultMenu;
    }

    @Override
    public MenuBar getMenuBar() {
        return this.ChecklistMenuBar;
    }

    private void ImportXCCDFData() {
        List FilesList;
        FileChooser fileSelector = new FileChooser();
        fileSelector.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("XCCDF Files(*.xml)", new String[]{"*.xml"}));
        if (!this.currentFileDirectory.equals("")) {
            fileSelector.setInitialDirectory(new File(this.currentFileDirectory));
        }
        if ((FilesList = fileSelector.showOpenMultipleDialog((Window)stigviewer.getPrimaryStage())) != null) {
            for (File currentFile : FilesList) {
                this.ChecklistDriverParent.ImportXCCDFResults(currentFile);
            }
        }
    }

    private File ExportToSaveFormat() throws NoFileSelected, IOException {
        FileChooser fileSelector = new FileChooser();
        fileSelector.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Checklist files(*.ckl)", new String[]{"*.ckl"}));
        File FileToWrite = this.exportFileSelector(fileSelector);
        this.ChecklistDriverParent.SaveToCklFile(FileToWrite);
        return FileToWrite;
    }

    private void ExportToCSVFormat() throws IOException, NoFileSelected {
        HashSet<String> selected = new HashSet<String>(CSV_Writer.checklistFields);
        ListSelectionDialog lsd = new ListSelectionDialog(CSV_Writer.checklistFields, selected);
        lsd.setTitle("Select fields to export");
        lsd.setMinimumSelectionCount(1);
        Optional fields = lsd.showAndWait();
        if (fields.isPresent()) {
            FileChooser fileSelector = new FileChooser();
            fileSelector.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("csv files(*.csv)", new String[]{"*.csv"}));
            File FileToWrite = this.exportFileSelector(fileSelector);
            String sUse = FileToWrite.getAbsolutePath();
            CSV_Writer.exportCheckList(this.ChecklistDriverParent.getCurrentSTIGs(), this.ChecklistDriverParent, sUse, new HashSet<String>((Collection)fields.get()));
        }
    }

    private void ExportToCMRSFormat() throws NoFileSelected {
        FileChooser fileSelector = new FileChooser();
        fileSelector.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("CMRS XML(*.xml)", new String[]{"*.xml"}));
        File FileToWrite = this.exportFileSelector(fileSelector);
        CMRS_Writer.getCMRS_Writer().writeCMRS(FileToWrite, this.ChecklistDriverParent.getChecklist());
    }

    private void ChecklistCompareSelection() throws NoFileSelected {
        FileChooser fileSelector = new FileChooser();
        fileSelector.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("STIG VIEWER CHECKLIST(*.ckl)", new String[]{"*.ckl"}));
        File FileToWrite = this.importFileSelector(fileSelector);
        this.CklCmp.setFile(FileToWrite);
    }

    private File importFileSelector(FileChooser fChoose) throws NoFileSelected {
        File FileToWrite;
        if (!this.currentFileDirectory.equals("")) {
            fChoose.setInitialDirectory(new File(this.currentFileDirectory));
        }
        if ((FileToWrite = fChoose.showOpenDialog((Window)stigviewer.getPrimaryStage())) == null) {
            throw new NoFileSelected("No file selected in FileChooser before \"Cancel\" or \"X\" selected, file list set as null");
        }
        this.setCurrentFileDirectory(FileToWrite.getParent());
        return FileToWrite;
    }

    private File exportFileSelector(FileChooser fChoose) throws NoFileSelected {
        File FileToWrite;
        if (!this.currentFileDirectory.equals("")) {
            fChoose.setInitialDirectory(new File(this.currentFileDirectory));
        }
        if ((FileToWrite = fChoose.showSaveDialog((Window)stigviewer.getPrimaryStage())) == null) {
            throw new NoFileSelected("No file selected in FileChooser before \"Cancel\" or \"X\" selected, file list set as null");
        }
        this.setCurrentFileDirectory(FileToWrite.getParent());
        return FileToWrite;
    }

    private void setCurrentFileDirectory(String Path2) {
        this.currentFileDirectory = Path2;
    }

    public void triggerImport() {
        this.FileSaveChecklist.fire();
    }
}

