/*
 * Decompiled with CFR 0.152.
 */
package File_Operations.File_Readers;

import File_Operations.File_Objects.Checklist;
import File_Operations.File_Objects.STIG;
import File_Operations.File_Objects.Vuln;
import File_Operations.Legacy.File_Interfaces.CCIReader;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class Checklist_Read {
    private static Checklist_Read reader;
    private Checklist Ckl = new Checklist();

    private Checklist_Read() {
    }

    public static Checklist_Read getChecklist_Read_2x() {
        if (reader == null) {
            reader = new Checklist_Read();
        }
        return reader;
    }

    public Checklist ParseCkl(XMLStreamReader XMLR) {
        this.Ckl = new Checklist();
        this.parseAsset(XMLR);
        this.parseSTIGs(XMLR);
        return this.Ckl;
    }

    private void parseAsset(XMLStreamReader XMLR) {
        try {
            while (XMLR.hasNext()) {
                XMLR.next();
                if (XMLR.isStartElement()) {
                    switch (XMLR.getName().getLocalPart()) {
                        case "ROLE": {
                            this.Ckl.setRole(XMLR.getElementText());
                            break;
                        }
                        case "ASSET_TYPE": {
                            this.Ckl.setIsComputing(XMLR.getElementText());
                            break;
                        }
                        case "HOST_NAME": {
                            this.Ckl.setHostName(XMLR.getElementText());
                            break;
                        }
                        case "HOST_IP": {
                            this.Ckl.setIPAddress(XMLR.getElementText());
                            break;
                        }
                        case "HOST_MAC": {
                            this.Ckl.setMACAddress(XMLR.getElementText());
                            break;
                        }
                        case "HOST_GUID": {
                            this.Ckl.setGUID(XMLR.getElementText());
                            break;
                        }
                        case "HOST_FQDN": {
                            this.Ckl.setFullyQualifiedDN(XMLR.getElementText());
                            break;
                        }
                        case "TECH_AREA": {
                            this.Ckl.setTechnologyArea(XMLR.getElementText());
                            break;
                        }
                        case "TARGET_KEY": {
                            this.Ckl.setTargetKey(XMLR.getElementText());
                            break;
                        }
                        case "WEB_OR_DATABASE": {
                            if (XMLR.getElementText().equalsIgnoreCase("false")) {
                                this.Ckl.setBIsWebDB(false);
                                break;
                            }
                            this.Ckl.setBIsWebDB(true);
                            break;
                        }
                        case "WEB_DB_SITE": {
                            this.Ckl.setSite(XMLR.getElementText());
                            break;
                        }
                        case "WEB_DB_INSTANCE": {
                            this.Ckl.setInstance(XMLR.getElementText());
                            break;
                        }
                    }
                    continue;
                }
                if (!XMLR.isEndElement() || !XMLR.getLocalName().equals("ASSET")) continue;
                break;
            }
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(Checklist_Read.class.getName()).log(Level.SEVERE, "SEVERE: CR: 1: Error occured while opening a Checklist");
        }
    }

    private void parseSTIGs(XMLStreamReader XMLR) {
        ArrayList<STIG> cklSt = new ArrayList<STIG>();
        try {
            while (XMLR.hasNext()) {
                XMLR.next();
                STIG st = new STIG();
                if (XMLR.isStartElement() && XMLR.getLocalName().equals("iSTIG")) {
                    st = this.parseSTIGInfo(XMLR);
                    this.parseSTIGData(XMLR, st);
                    cklSt.add(st);
                    continue;
                }
                if (!XMLR.isEndElement() || !XMLR.getLocalName().equals("CHECKLIST")) {
                    if (!XMLR.isStartElement() || !XMLR.getLocalName().equals("STIG_INFO")) continue;
                    st = this.parseSTIGInfo(XMLR);
                    this.parseSTIGData(XMLR, st);
                    cklSt.add(st);
                    continue;
                }
                break;
            }
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(Checklist_Read.class.getName()).log(Level.SEVERE, "SEVERE: CR: 2: Error occured while opening a Checklist");
        }
        this.Ckl.setChecklistSTIGList(cklSt);
    }

    private STIG parseSTIGInfo(XMLStreamReader XMLR) {
        STIG st = new STIG();
        String input = "";
        try {
            while (XMLR.hasNext()) {
                XMLR.next();
                if (XMLR.isStartElement() && XMLR.getLocalName().equals("SID_NAME")) {
                    input = XMLR.getElementText();
                    continue;
                }
                if (XMLR.isStartElement() && XMLR.getLocalName().equals("SID_DATA")) {
                    switch (input) {
                        case "version": {
                            st.setSTIG_Version(XMLR.getElementText());
                            break;
                        }
                        case "classification": {
                            st.setSTIG_Classification(XMLR.getElementText());
                            break;
                        }
                        case "customname": {
                            st.setSTIG_CustomName(XMLR.getElementText());
                            break;
                        }
                        case "stigid": {
                            st.setSTIG_BID(XMLR.getElementText());
                            break;
                        }
                        case "description": {
                            st.setSTIG_Description(XMLR.getElementText());
                            break;
                        }
                        case "filename": {
                            st.setSTIG_FileName(XMLR.getElementText());
                            break;
                        }
                        case "releaseinfo": {
                            st.setSTIG_Release_Info(XMLR.getElementText());
                            break;
                        }
                        case "title": {
                            st.setSTIG_Title(XMLR.getElementText());
                            break;
                        }
                        case "uuid": {
                            st.setUUID(UUID.fromString(XMLR.getElementText()));
                            break;
                        }
                        case "notice": {
                            st.setSTIG_notice(XMLR.getElementText());
                            break;
                        }
                        case "source": {
                            st.setSTIG_source(XMLR.getElementText());
                        }
                    }
                    input = "";
                    continue;
                }
                if (!XMLR.isEndElement() || !XMLR.getLocalName().equals("STIG_INFO")) continue;
                break;
            }
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(Checklist_Read.class.getName()).log(Level.SEVERE, "SEVERE: CR: 3: Error occured while opening a Checklist");
        }
        if (st.getSTIG_Title().isEmpty()) {
            st.setSTIG_Title("CustomSTIG");
        }
        return st;
    }

    private void parseSTIGData(XMLStreamReader XMLR, STIG st) {
        String input = "";
        Vuln v = new Vuln();
        try {
            while (XMLR.hasNext()) {
                XMLR.next();
                if (XMLR.isStartElement() && XMLR.getLocalName().equals("VULN")) {
                    v = new Vuln();
                    continue;
                }
                if (XMLR.isStartElement() && XMLR.getLocalName().equals("VULN_ATTRIBUTE")) {
                    input = XMLR.getElementText();
                    continue;
                }
                if (XMLR.isStartElement() && XMLR.getLocalName().equals("ATTRIBUTE_DATA")) {
                    switch (input) {
                        case "Vuln_Num": {
                            v.setAttr(Vuln.VulnAttr.Vuln_Num, XMLR.getElementText());
                            break;
                        }
                        case "Severity": {
                            v.setAttr(Vuln.VulnAttr.Severity, XMLR.getElementText());
                            break;
                        }
                        case "Group_Title": {
                            v.setAttr(Vuln.VulnAttr.Group_Title, XMLR.getElementText());
                            break;
                        }
                        case "Rule_ID": {
                            v.setAttr(Vuln.VulnAttr.Rule_ID, XMLR.getElementText());
                            break;
                        }
                        case "Rule_Ver": {
                            v.setAttr(Vuln.VulnAttr.Rule_Ver, XMLR.getElementText());
                            break;
                        }
                        case "Rule_Title": {
                            v.setAttr(Vuln.VulnAttr.Rule_Title, XMLR.getElementText());
                            break;
                        }
                        case "Vuln_Discuss": {
                            v.setAttr(Vuln.VulnAttr.Vuln_Discuss, XMLR.getElementText());
                            break;
                        }
                        case "IA_Controls": {
                            v.setAttr(Vuln.VulnAttr.IA_Controls, XMLR.getElementText());
                            break;
                        }
                        case "Check_Content": {
                            v.setAttr(Vuln.VulnAttr.Check_Content, XMLR.getElementText());
                            break;
                        }
                        case "Fix_Text": {
                            v.setAttr(Vuln.VulnAttr.Fix_Text, XMLR.getElementText());
                            break;
                        }
                        case "False_Positives": {
                            v.setAttr(Vuln.VulnAttr.False_Positives, XMLR.getElementText());
                            break;
                        }
                        case "False_Negatives": {
                            v.setAttr(Vuln.VulnAttr.False_Negatives, XMLR.getElementText());
                            break;
                        }
                        case "Documentable": {
                            v.setAttr(Vuln.VulnAttr.Documentable, XMLR.getElementText());
                            break;
                        }
                        case "Mitigations": {
                            v.setAttr(Vuln.VulnAttr.Mitigations, XMLR.getElementText());
                            break;
                        }
                        case "Potential_Impact": {
                            v.setAttr(Vuln.VulnAttr.Potential_Impact, XMLR.getElementText());
                            break;
                        }
                        case "Third_Party_Tools": {
                            v.setAttr(Vuln.VulnAttr.Third_Party_Tools, XMLR.getElementText());
                            break;
                        }
                        case "Mitigation_Control": {
                            v.setAttr(Vuln.VulnAttr.Mitigation_Control, XMLR.getElementText());
                            break;
                        }
                        case "Responsibility": {
                            v.setAttr(Vuln.VulnAttr.Responsibility, XMLR.getElementText());
                            break;
                        }
                        case "Security_Override_Guidance": {
                            v.setAttr(Vuln.VulnAttr.Security_Override_Guidance, XMLR.getElementText());
                            break;
                        }
                        case "Check_Content_Ref": {
                            v.setAttr(Vuln.VulnAttr.Check_Content_Ref, XMLR.getElementText());
                            break;
                        }
                        case "Weight": {
                            v.setAttr(Vuln.VulnAttr.Weight, XMLR.getElementText());
                            break;
                        }
                        case "Class": {
                            v.setAttr(Vuln.VulnAttr.Class, XMLR.getElementText());
                            break;
                        }
                        case "STIGRef": {
                            v.setAttr(Vuln.VulnAttr.STIGRef, XMLR.getElementText());
                            break;
                        }
                        case "TargetKey": {
                            v.setAttr(Vuln.VulnAttr.TargetKey, XMLR.getElementText());
                            break;
                        }
                        case "CCI_REF": {
                            st.setHasCCI(true);
                            ArrayList<String> ccilist = v.GetCCIVals();
                            ccilist.add(XMLR.getElementText());
                            v.setCCIs(ccilist);
                        }
                    }
                    input = "";
                    continue;
                }
                if (XMLR.isStartElement() && XMLR.getLocalName().equals("STATUS")) {
                    v.setCheckState(Vuln.CheckState.valueOf(XMLR.getElementText()));
                    continue;
                }
                if (XMLR.isStartElement() && XMLR.getLocalName().equals("FINDING_DETAILS")) {
                    v.setCHK_Notes(XMLR.getElementText());
                    continue;
                }
                if (XMLR.isStartElement() && XMLR.getLocalName().equals("COMMENTS")) {
                    v.setCheckComment(XMLR.getElementText());
                    continue;
                }
                if (XMLR.isStartElement() && XMLR.getLocalName().equals("SEVERITY_OVERRIDE")) {
                    v.setCheckSevOverride(XMLR.getElementText());
                    continue;
                }
                if (XMLR.isStartElement() && XMLR.getLocalName().equals("SEVERITY_JUSTIFICATION")) {
                    v.setCheckSevJust(XMLR.getElementText());
                    continue;
                }
                if (XMLR.isEndElement() && XMLR.getLocalName().equals("VULN")) {
                    this.populateCCI(v);
                    st.addVulnObj(v);
                    continue;
                }
                if (!XMLR.isEndElement() || !XMLR.getLocalName().equals("iSTIG")) continue;
                break;
            }
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(Checklist_Read.class.getName()).log(Level.SEVERE, "SEVERE: CR: 4: Error occured while opening a Checklist");
        }
    }

    private void populateCCI(Vuln v) {
        ArrayList<CCIReader.CCI_Store> ccis = new ArrayList<CCIReader.CCI_Store>();
        for (String s : v.GetCCIVals()) {
            ccis.add(CCIReader.getCCIReader().getCCIbyName(s));
        }
        v.setCCI((ArrayList)ccis.clone());
    }
}

