#
# Copyright (c) 2015-2017 Brendan Coles <bcoles@gmail.com>
# SSRF Proxy - https://github.com/bcoles/ssrf_proxy
# See the file 'LICENSE.md' for copying permission
#
require './lib/ssrf_proxy/version'

Gem::Specification.new do |spec|
  spec.name          = 'ssrf_proxy'
  spec.version       = SSRFProxy::VERSION
  spec.date          = '2017-12-22'
  spec.authors       = ['Brendan Coles']
  spec.email         = ['bcoles@gmail.com']

  spec.summary       = 'SSRF Proxy facilitates tunneling HTTP ' \
                       'communications through servers vulnerable to SSRF.'
  spec.description   = 'SSRF Proxy is a multi-threaded HTTP proxy server ' \
                       'designed to tunnel client HTTP traffic through HTTP ' \
                       'servers vulnerable to HTTP Server-Side Request ' \
                       'Forgery (SSRF).'
  spec.homepage      = 'https://github.com/bcoles/ssrf_proxy'
  spec.license       = 'MIT'

  spec.files         = Dir.glob('*.md') +
                       Dir.glob('lib/**/*') +
                       Dir.glob('bin/**/*')
  spec.bindir        = 'bin'
  spec.executables   = ['ssrf-proxy']
  spec.require_paths = ['lib']

  spec.has_rdoc = true
  spec.extra_rdoc_files = %w{README.md LICENSE.md}
  spec.rdoc_options << '--title' << 'SSRF Proxy' <<
                       '--main'  << 'README.md' <<
                       '--line-numbers'

  spec.required_ruby_version = '>= 2.2.2'
  spec.add_development_dependency 'bundler'
  spec.add_development_dependency 'coveralls'
  spec.add_development_dependency 'minitest'
  spec.add_development_dependency 'minitest-reporters'
  spec.add_development_dependency 'rake'
  spec.add_development_dependency 'rdoc'
  spec.add_development_dependency 'rubocop'
  spec.add_development_dependency 'simplecov'
  spec.add_development_dependency 'terminal-table'
  spec.add_development_dependency 'typhoeus'
  spec.add_development_dependency 'yard'

  spec.add_dependency 'base32'
  spec.add_dependency 'celluloid'
  spec.add_dependency 'celluloid-io'
  spec.add_dependency 'colorize'
  spec.add_dependency 'htmlentities'
  spec.add_dependency 'ipaddress'
  spec.add_dependency 'logger'
  spec.add_dependency 'mimemagic'
  spec.add_dependency 'socksify'
  spec.add_dependency 'webrick'
end
