/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.lib.System2;
import org.sonarsource.scanner.lib.internal.Paths2;

public class OsResolver {
    private static final Logger LOG = LoggerFactory.getLogger(OsResolver.class);
    private final System2 system;
    private final Paths2 paths;

    public OsResolver(System2 system, Paths2 paths) {
        this.system = system;
        this.paths = paths;
    }

    public OperatingSystem getOs() {
        String osName = this.system.getProperty("os.name");
        if (osName != null) {
            String osNameLowerCase = osName.toLowerCase(Locale.ENGLISH);
            if (osNameLowerCase.contains("mac") || osNameLowerCase.contains("darwin")) {
                return OperatingSystem.MACOS;
            }
            if (osNameLowerCase.contains("win")) {
                return OperatingSystem.WINDOWS;
            }
            if (osNameLowerCase.contains("linux")) {
                return this.isAlpine() ? OperatingSystem.ALPINE : OperatingSystem.LINUX;
            }
        }
        throw new IllegalStateException(String.format("Failed to detect OS, use the property '%s' to set it manually.", "sonar.scanner.os"));
    }

    private boolean isAlpine() {
        List<String> content;
        try {
            content = Files.readAllLines(this.paths.get("/etc/os-release", new String[0]));
        }
        catch (IOException e) {
            try {
                content = Files.readAllLines(this.paths.get("/usr/lib/os-release", new String[0]));
            }
            catch (IOException e2) {
                e2.addSuppressed(e);
                LOG.debug("Failed to read the os-release file", e2);
                return false;
            }
        }
        return content.stream().anyMatch(line -> line.matches("^ID=alpine$"));
    }

    public static enum OperatingSystem {
        LINUX,
        WINDOWS,
        MACOS,
        ALPINE;

    }
}

