/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.cli;

import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.cli.ScannerVersion;

class SystemInfo {
    private static final Logger LOG = LoggerFactory.getLogger(SystemInfo.class);
    private static final Set<String> SENSITIVE_JVM_ARGUMENTS = Set.of("-Dsonar.login", "-Dsonar.password", "-Dsonar.token");
    private static final Pattern PATTERN_ARGUMENT_SEPARATOR = Pattern.compile("\\s+");
    private static System2 system = new System2();

    private SystemInfo() {
    }

    static void setSystem(System2 system) {
        SystemInfo.system = system;
    }

    static void print() {
        LOG.info("SonarScanner CLI {}", (Object)ScannerVersion.version());
        LOG.atInfo().log(SystemInfo::java);
        LOG.atInfo().log(SystemInfo::os);
        String scannerOpts = system.getenv("SONAR_SCANNER_OPTS");
        if (scannerOpts != null) {
            LOG.atInfo().addArgument(() -> SystemInfo.redactSensitiveArguments(scannerOpts)).log("SONAR_SCANNER_OPTS={}");
        }
    }

    private static String redactSensitiveArguments(String scannerOpts) {
        return PATTERN_ARGUMENT_SEPARATOR.splitAsStream(scannerOpts).map(SystemInfo::redactArgumentIfSensistive).collect(Collectors.joining(" "));
    }

    private static String redactArgumentIfSensistive(String argument) {
        String[] elems = argument.split("=");
        if (elems.length > 0 && SENSITIVE_JVM_ARGUMENTS.contains(elems[0])) {
            return elems[0] + "=*";
        }
        return argument;
    }

    static String java() {
        StringBuilder sb = new StringBuilder();
        sb.append("Java ").append(system.getProperty("java.version")).append(" ").append(system.getProperty("java.vendor"));
        String bits = system.getProperty("sun.arch.data.model");
        if ("32".equals(bits) || "64".equals(bits)) {
            sb.append(" (").append(bits).append("-bit)");
        }
        return sb.toString();
    }

    static String os() {
        return system.getProperty("os.name") + " " + system.getProperty("os.version") + " " + system.getProperty("os.arch");
    }

    static class System2 {
        System2() {
        }

        String getProperty(String key) {
            return System.getProperty(key);
        }

        String getenv(String key) {
            return System.getenv(key);
        }
    }
}

