/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp11.tests;

import org.w3c.dom.Element;
import org.wsi.test.validator.Assertion;
import org.wsi.test.validator.Entry;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.bsp11.SecureConstants;
import org.wsi.test.validator.bsp11.entrytypes.EncDataReferenceEntryType;

public class BSP5608
extends Assertion {
    public BSP5608(Element el) {
        super(el);
    }

    public boolean isApplicable(Entry e) {
        return e instanceof EncDataReferenceEntryType;
    }

    public boolean applyRule(Entry entry) {
        Element referencedElement;
        EncDataReferenceEntryType encDataReferenceEntry = (EncDataReferenceEntryType)entry;
        try {
            referencedElement = encDataReferenceEntry.itemReferenced();
        }
        catch (ValidatorException e) {
            return false;
        }
        if (referencedElement == null) {
            return false;
        }
        return this.isEncryptedData(referencedElement) || this.isEncryptedHeader(referencedElement);
    }

    private boolean isEncryptedData(Element e) {
        return e.getNamespaceURI().equals(SecureConstants.XENC_NAMESPACE) && e.getLocalName().equals("EncryptedData");
    }

    private boolean isEncryptedHeader(Element e) {
        return e.getNamespaceURI().equals(SecureConstants.WSSE11_NAMESPACE) && e.getLocalName().equals("EncryptedHeader");
    }
}

