/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp11.entrytypes;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.bsp11.SecureConstants;
import org.wsi.test.validator.bsp11.entrytypes.SecureEntryType;

public abstract class ReferenceEntryType
extends SecureEntryType {
    protected ReferenceEntryType(Element el) {
        super(el);
    }

    private boolean uriReferencesElement(String uri, Element el) {
        if (el.hasAttributeNS(SecureConstants.WSU_NAMESPACE, "Id") && el.getAttributeNS(SecureConstants.WSU_NAMESPACE, "Id").equals(uri)) {
            return true;
        }
        return el.hasAttribute("Id") && el.getAttribute("Id").equals(uri);
    }

    public Element itemReferenced() throws ValidatorException {
        String uri = this.getElement().getAttribute("URI");
        if (uri.equals("") || uri.charAt(0) != '#') {
            return null;
        }
        uri = uri.substring(1);
        Element envelope = this.getElement().getOwnerDocument().getDocumentElement();
        Element referencedElement = null;
        if (this.uriReferencesElement(uri, envelope)) {
            referencedElement = envelope;
        }
        NodeList allElements = envelope.getElementsByTagName("*");
        int i = 0;
        while (i < allElements.getLength()) {
            Element thisEl = (Element)allElements.item(i);
            if (this.uriReferencesElement(uri, thisEl)) {
                if (referencedElement == null) {
                    referencedElement = thisEl;
                } else {
                    throw new ValidatorException("STR_REFERENCE with uri = " + uri + " points to two elements");
                }
            }
            ++i;
        }
        return referencedElement;
    }
}

