/*
 * Decompiled with CFR 0.152.
 */
package hermes.taglib;

import java.util.Date;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.Logger;

public class DestinationStatisticsBean {
    private static final Logger log = Logger.getLogger(DestinationStatisticsBean.class);
    private static final FastDateFormat dateFormat = FastDateFormat.getInstance((String)"MM/dd/yyyy HH:mm:ss");
    private String name;
    private String hermes;
    private Date oldest;
    private int depth;

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOldest() {
        if (this.oldest != null) {
            return dateFormat.format(this.oldest);
        }
        return "empty";
    }

    public void setOldest(Date oldest) {
        this.oldest = oldest;
    }

    private String plural(int n) {
        if (n > 1) {
            return "s";
        }
        return "";
    }

    public String getAge() {
        if (this.oldest != null) {
            Date now = new Date();
            Date then = this.oldest;
            long diff = (now.getTime() - then.getTime()) / 1000L;
            int days = (int)diff / 86400;
            int hours = (int)(diff % 86400L) / 3600;
            int mins = (int)(diff % 360L) / 60;
            int secs = (int)(diff % 60L);
            StringBuffer rval = new StringBuffer();
            if (days > 0) {
                rval.append(days).append(" day").append(this.plural(days)).append(" ");
            }
            if (hours > 0) {
                rval.append(hours).append(" hour").append(this.plural(hours)).append(" ");
            }
            if (mins > 0) {
                rval.append(mins).append(" minute").append(this.plural(mins)).append(" ");
            }
            if (secs > 0) {
                rval.append(secs).append(" second").append(this.plural(secs)).append(" ");
            }
            return rval.toString();
        }
        return "empty";
    }

    public String getHermes() {
        return this.hermes;
    }

    public void setHermes(String hermes) {
        this.hermes = hermes;
    }
}

