/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl;

import hermes.Domain;
import hermes.Hermes;
import hermes.HermesException;
import hermes.NullConnectionFactory;
import hermes.SystemProperties;
import hermes.config.ClasspathConfig;
import hermes.config.ClasspathGroupConfig;
import hermes.config.ConnectionConfig;
import hermes.config.DestinationConfig;
import hermes.config.FactoryConfig;
import hermes.config.HermesConfig;
import hermes.config.JDBCStore;
import hermes.config.NamingConfig;
import hermes.config.ObjectFactory;
import hermes.config.PropertyConfig;
import hermes.config.PropertySetConfig;
import hermes.config.ProviderConfig;
import hermes.config.ProviderExtConfig;
import hermes.config.RendererConfig;
import hermes.config.SessionConfig;
import hermes.config.WatchConfig;
import hermes.ext.DefaultHermesAdminFactory;
import hermes.impl.ConfigDAO;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;

public class ConfigDAOImpl
implements ConfigDAO {
    private static final Logger log = Logger.getLogger(ConfigDAOImpl.class);
    private final ObjectFactory factory = new ObjectFactory();
    private final Properties adminProperties = new Properties();
    private final Collection<String> adminFactories = new ArrayList<String>();
    private final String ADMIN_FACTORIES = "admin.factories";
    private final Map<String, URL> adminFactoryToJARMap = new HashMap<String, URL>();
    private final Map<String, String> adminFactoryToPlugIn = new HashMap<String, String>();
    private final Map<String, String> plugInToAdminFactory = new HashMap<String, String>();
    private URL[] adminFactoryURLs = null;

    public ConfigDAOImpl() {
        ArrayList<URL> adminFactoryList = new ArrayList<URL>();
        try {
            this.adminProperties.load(ConfigDAOImpl.class.getClassLoader().getResourceAsStream("hermes/impl/confighelper.properties"));
            log.debug((Object)this.adminProperties);
            if (this.adminProperties.containsKey("admin.factories")) {
                StringTokenizer tokens = new StringTokenizer(this.adminProperties.getProperty("admin.factories"), ",");
                while (tokens.hasMoreTokens()) {
                    String adminFactoryClass = tokens.nextToken();
                    this.adminFactories.add(adminFactoryClass);
                    log.debug((Object)("factory=" + adminFactoryClass));
                    if (!this.adminProperties.containsKey(adminFactoryClass)) continue;
                    String libraryPair = (String)this.adminProperties.get(adminFactoryClass);
                    String[] split = libraryPair.split(",");
                    String library = SystemProperties.EXT_LIBRARY_PATH + "/" + split[0];
                    String libraryLongName = split[1];
                    this.adminFactoryToPlugIn.put(adminFactoryClass, libraryLongName);
                    if (library.startsWith("http")) {
                        log.debug((Object)(libraryLongName + "(" + adminFactoryClass + ") lives in " + library));
                        this.adminFactoryToJARMap.put(adminFactoryClass, new URL(library));
                        this.plugInToAdminFactory.put(libraryLongName, adminFactoryClass);
                        continue;
                    }
                    File libraryFile = new File(library);
                    if (libraryFile.exists()) {
                        log.debug((Object)(libraryLongName + "(" + adminFactoryClass + ") lives in " + library));
                        this.adminFactoryToJARMap.put(adminFactoryClass, libraryFile.toURL());
                        this.plugInToAdminFactory.put(libraryLongName, adminFactoryClass);
                        adminFactoryList.add(libraryFile.toURL());
                        continue;
                    }
                    log.error((Object)("cannot find " + library + " for " + adminFactoryClass));
                }
            }
        }
        catch (IOException e) {
            log.error((Object)("Cannot load confighelper.properties from the ClassLoader: " + e.getMessage()), (Throwable)e);
        }
        this.adminFactoryURLs = new URL[adminFactoryList.size()];
        int i = 0;
        for (URL url : adminFactoryList) {
            this.adminFactoryURLs[i++] = url;
        }
    }

    @Override
    public ObjectFactory getFactory() {
        return this.factory;
    }

    @Override
    public String getAdminClassForPlugIn(String plugin) {
        if (this.plugInToAdminFactory.containsKey(plugin)) {
            return this.plugInToAdminFactory.get(plugin);
        }
        return DefaultHermesAdminFactory.class.getName();
    }

    @Override
    public String getPlugInName(String adminFactoryClass) {
        if (this.adminFactoryToPlugIn.containsKey(adminFactoryClass)) {
            return this.adminFactoryToPlugIn.get(adminFactoryClass);
        }
        return "Default";
    }

    @Override
    public URL[] getAdminFactoryURLs() {
        return this.adminFactoryURLs;
    }

    @Override
    public URL getURLForAdminFactory(String adminFactoryClass) {
        return this.adminFactoryToJARMap.get(adminFactoryClass);
    }

    @Override
    public void removeJDBC(HermesConfig config, JDBCStore store) {
        config.getJdbcStore().remove(store);
    }

    @Override
    public JDBCStore addJDBCStore(HermesConfig config, String alias, String driver, String url) throws JAXBException {
        JDBCStore storeConfig = this.factory.createJDBCStore();
        storeConfig.setAlias(alias);
        storeConfig.setDriver(driver);
        storeConfig.setUrl(url);
        Iterator<JDBCStore> iter = config.getJdbcStore().iterator();
        while (iter.hasNext()) {
            JDBCStore existing = iter.next();
            if (!existing.getAlias().equals(alias)) continue;
            iter.remove();
        }
        config.getJdbcStore().add(storeConfig);
        return storeConfig;
    }

    @Override
    public void removeNamingConfig(HermesConfig config, String id) {
        Iterator<NamingConfig> iter = config.getNaming().iterator();
        while (iter.hasNext()) {
            NamingConfig namingConfig = iter.next();
            if (!namingConfig.getId().equals(id)) continue;
            iter.remove();
        }
    }

    @Override
    public ClasspathGroupConfig getClasspathGroupConfig(HermesConfig config, String id) {
        for (ClasspathGroupConfig gConfig : config.getClasspathGroup()) {
            if (!gConfig.getId().equals(id)) continue;
            return gConfig;
        }
        return null;
    }

    @Override
    public ClasspathConfig duplicate(ClasspathConfig cConfig) throws JAXBException {
        ClasspathConfig newCConfig = this.factory.createClasspathConfig();
        newCConfig.setFactories(cConfig.getFactories());
        newCConfig.setJar(cConfig.getJar());
        newCConfig.setNoFactories(cConfig.isNoFactories());
        return newCConfig;
    }

    @Override
    public List<ClasspathGroupConfig> duplicateClasspathGroups(List<?> classPathGroups) throws JAXBException {
        ArrayList<ClasspathGroupConfig> rval = new ArrayList<ClasspathGroupConfig>();
        for (ClasspathGroupConfig gConfig : classPathGroups) {
            ClasspathGroupConfig newGConfig = this.factory.createClasspathGroupConfig();
            newGConfig.setId(gConfig.getId());
            rval.add(newGConfig);
            for (ClasspathConfig cConfig : gConfig.getLibrary()) {
                ClasspathConfig newCConfig = this.duplicate(cConfig);
                newGConfig.getLibrary().add(newCConfig);
            }
        }
        return rval;
    }

    @Override
    public void removeHermes(HermesConfig config, String hermesId) throws HermesException {
        for (FactoryConfig factoryConfig : config.getFactory()) {
            for (DestinationConfig destinationConfig : factoryConfig.getDestination()) {
            }
            for (ConnectionConfig connectionConfig : factoryConfig.getConnection()) {
                Iterator<SessionConfig> iter4 = connectionConfig.getSession().iterator();
                while (iter4.hasNext()) {
                    SessionConfig sessionConfig = iter4.next();
                    if (sessionConfig.getId() == null) {
                        iter4.remove();
                        continue;
                    }
                    if (!sessionConfig.getId().equals(hermesId)) continue;
                    iter4.remove();
                    log.debug((Object)(hermesId + " removed"));
                    return;
                }
            }
        }
        throw new HermesException("no session " + hermesId);
    }

    @Override
    public void removeDestination(HermesConfig config, String hermesId, String destinationName) throws HermesException {
        for (FactoryConfig factoryConfig : config.getFactory()) {
            for (ConnectionConfig connectionConfig : factoryConfig.getConnection()) {
                for (SessionConfig sessionConfig : connectionConfig.getSession()) {
                    if (!sessionConfig.getId().equals(hermesId)) continue;
                    Iterator<DestinationConfig> iter2 = factoryConfig.getDestination().iterator();
                    while (iter2.hasNext()) {
                        DestinationConfig destinationConfig = iter2.next();
                        if (!destinationConfig.getName().equals(destinationName)) continue;
                        log.debug((Object)(destinationName + " removed."));
                        iter2.remove();
                        return;
                    }
                }
            }
        }
        throw new HermesException("no destination " + destinationName + " configured for session " + hermesId);
    }

    @Override
    public Collection<SessionConfig> getAllSessions(HermesConfig config) throws HermesException {
        ArrayList<SessionConfig> rval = new ArrayList<SessionConfig>();
        for (FactoryConfig factoryConfig : config.getFactory()) {
            for (ConnectionConfig connectionConfig : factoryConfig.getConnection()) {
                for (SessionConfig sessionConfig : connectionConfig.getSession()) {
                    rval.add(sessionConfig);
                }
            }
        }
        return rval;
    }

    @Override
    public Collection getAllDestinations(HermesConfig config, String hermesId) throws HermesException {
        ArrayList<DestinationConfig> rval = new ArrayList<DestinationConfig>();
        for (FactoryConfig factoryConfig : config.getFactory()) {
            for (ConnectionConfig connectionConfig : factoryConfig.getConnection()) {
                Iterator<SessionConfig> iter3 = connectionConfig.getSession().iterator();
                while (iter3.hasNext()) {
                    SessionConfig sessionConfig = iter3.next();
                    if (sessionConfig.getId() == null) {
                        log.debug((Object)"session with a null id removed");
                        iter3.remove();
                        continue;
                    }
                    if (hermesId != null && !sessionConfig.getId().equals(hermesId)) continue;
                    Iterator<DestinationConfig> iter4 = factoryConfig.getDestination().iterator();
                    while (iter4.hasNext()) {
                        rval.add(iter4.next());
                    }
                }
            }
        }
        return rval;
    }

    @Override
    public Properties getRendererProperties(RendererConfig rConfig) {
        Properties props = new Properties();
        if (rConfig.getProperties() != null) {
            for (PropertyConfig pConfig : rConfig.getProperties().getProperty()) {
                props.put(pConfig.getName(), pConfig.getValue());
            }
        }
        return props;
    }

    @Override
    public Properties getRendererProperties(HermesConfig config, String className) throws HermesException {
        Properties props = new Properties();
        for (RendererConfig rConfig : config.getRenderer()) {
            if (!rConfig.getClassName().equals(className)) continue;
            return this.getRendererProperties(rConfig);
        }
        throw new HermesException("no such renderer " + className);
    }

    @Override
    public RendererConfig createRendererConfig(String className, Map<?, ?> map) throws HermesException {
        try {
            RendererConfig rConfig = this.factory.createRendererConfig();
            rConfig.setClassName(className);
            PropertySetConfig properties = rConfig.getProperties();
            if (properties == null) {
                properties = new PropertySetConfig();
                rConfig.setProperties(properties);
            }
            this.populatePropertySet(map, properties);
            return rConfig;
        }
        catch (JAXBException e) {
            throw new HermesException((Exception)((Object)e));
        }
    }

    @Override
    public void updatePropertySet(PropertySetConfig properties, Map<?, ?> map) throws JAXBException {
        Iterator<PropertyConfig> iter = properties.getProperty().iterator();
        while (iter.hasNext()) {
            PropertyConfig pConfig = iter.next();
            if (!map.containsKey(pConfig.getName())) continue;
            iter.remove();
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            PropertyConfig pConfig = this.factory.createPropertyConfig();
            pConfig.setName((String)entry.getKey());
            if (entry.getValue() == null) continue;
            pConfig.setValue(entry.getValue().toString());
            properties.getProperty().add(pConfig);
        }
    }

    @Override
    public void populatePropertySet(Map<?, ?> map, PropertySetConfig properties) throws JAXBException {
        for (String key : map.keySet()) {
            String value;
            if (map.get(key) == null || (value = map.get(key).toString()).equals("") || key.equals("class") || key.equals("name")) continue;
            PropertyConfig pConfig = this.factory.createPropertyConfig();
            pConfig.setName(key);
            pConfig.setValue(value);
            properties.getProperty().add(pConfig);
        }
    }

    @Override
    public PropertySetConfig createPropertySet() throws HermesException {
        return this.factory.createPropertySetConfig();
    }

    @Override
    public void setRendererProperties(HermesConfig config, String className, Map<?, ?> props) throws HermesException, JAXBException {
        for (RendererConfig rConfig : config.getRenderer()) {
            if (!rConfig.getClassName().equals(className)) continue;
            if (rConfig.getProperties() == null) {
                rConfig.setProperties(new PropertySetConfig());
            }
            rConfig.getProperties().getProperty().clear();
            for (String key : props.keySet()) {
                if (props.get(key) == null) continue;
                String value = props.get(key).toString();
                if (key.equals("class") || key.equals("name")) continue;
                PropertyConfig pConfig = this.factory.createPropertyConfig();
                pConfig.setName(key);
                pConfig.setValue(value);
                rConfig.getProperties().getProperty().add(pConfig);
            }
            return;
        }
        throw new HermesException("no such renderer " + className);
    }

    @Override
    public WatchConfig createWatchConfig() {
        WatchConfig rval = new WatchConfig();
        rval.setShowAge(true);
        rval.setUpdateFrequency(30000L);
        return rval;
    }

    @Override
    public DestinationConfig createDestinationConfig() {
        return new DestinationConfig();
    }

    @Override
    public DestinationConfig createDestinationConfig(String name, Domain domain) {
        DestinationConfig rval = new DestinationConfig();
        rval.setName(name);
        rval.setDomain(domain.getId());
        return rval;
    }

    @Override
    public ProviderExtConfig createDefaultProviderExtConfig(String connectionFactoryName) throws JAXBException {
        ProviderExtConfig config = this.factory.createProviderExtConfig();
        if (this.adminProperties.containsKey(connectionFactoryName)) {
            config.setClassName((String)this.adminProperties.get(connectionFactoryName));
        } else {
            config.setClassName(DefaultHermesAdminFactory.class.getName());
        }
        config.setProperties(this.factory.createPropertySetConfig());
        return config;
    }

    @Override
    public DestinationConfig duplicateForWatch(DestinationConfig dConfig, Hermes hermes) {
        DestinationConfig rval = this.duplicate(dConfig);
        rval.setSelector(null);
        rval.setMyHermes(hermes.getId());
        return rval;
    }

    @Override
    public DestinationConfig duplicate(DestinationConfig dConfig) {
        DestinationConfig rval = new DestinationConfig();
        rval.setName(dConfig.getName());
        rval.setShortName(dConfig.getShortName());
        rval.setSelector(dConfig.getSelector());
        rval.setDomain(dConfig.getDomain());
        rval.setDurable(dConfig.isDurable());
        rval.setClientID(dConfig.getClientID());
        return rval;
    }

    @Override
    public Collection<String> getAdminFactories() {
        return this.adminFactories;
    }

    @Override
    public FactoryConfig createJNDIFactoryConfig(String classpathId, String sessionId, String binding, PropertySetConfig properties, String className) throws JAXBException {
        FactoryConfig factoryConfig = new FactoryConfig();
        factoryConfig.setClasspathId(classpathId);
        SessionConfig sessionConfig = new SessionConfig();
        ConnectionConfig connectConfig = new ConnectionConfig();
        ProviderConfig providerConfig = new ProviderConfig();
        sessionConfig.setId(sessionId);
        sessionConfig.setTransacted(true);
        sessionConfig.setReconnects(BigInteger.ZERO);
        connectConfig.getSession().add(sessionConfig);
        factoryConfig.getConnection().add(connectConfig);
        factoryConfig.setExtension(this.createDefaultProviderExtConfig(NullConnectionFactory.class.getName()));
        PropertySetConfig propertySet = this.factory.createPropertySetConfig();
        for (PropertyConfig pConfig : properties.getProperty()) {
            if (pConfig.getName().equals("binding")) continue;
            propertySet.getProperty().add(pConfig);
        }
        PropertyConfig bProperty = this.factory.createPropertyConfig();
        bProperty.setName("binding");
        bProperty.setValue(binding);
        propertySet.getProperty().add(bProperty);
        providerConfig.setProperties(propertySet);
        providerConfig.setClassName(className);
        factoryConfig.setProvider(providerConfig);
        return factoryConfig;
    }

    @Override
    public FactoryConfig createDefaultFactoryConfig(String sessionId) throws JAXBException {
        FactoryConfig factoryConfig = new FactoryConfig();
        factoryConfig.setClasspathId("System");
        SessionConfig sessionConfig = new SessionConfig();
        ConnectionConfig connectConfig = new ConnectionConfig();
        ProviderConfig providerConfig = new ProviderConfig();
        sessionConfig.setId(sessionId);
        connectConfig.getSession().add(sessionConfig);
        factoryConfig.getConnection().add(connectConfig);
        factoryConfig.setExtension(this.createDefaultProviderExtConfig(NullConnectionFactory.class.getName()));
        sessionConfig.setTransacted(true);
        providerConfig.setProperties(new PropertySetConfig());
        factoryConfig.setProvider(providerConfig);
        return factoryConfig;
    }

    @Override
    public void replaceDestinationConfigs(HermesConfig config, String hermesId, Collection<DestinationConfig> destinationConfigs) {
        for (FactoryConfig factoryConfig : config.getFactory()) {
            for (ConnectionConfig connConfig : factoryConfig.getConnection()) {
                for (SessionConfig sConfig : connConfig.getSession()) {
                    if (!sConfig.getId().equals(hermesId)) continue;
                    Iterator<DestinationConfig> iter = factoryConfig.getDestination().iterator();
                    while (iter.hasNext()) {
                        DestinationConfig dConfig = iter.next();
                        if (dConfig.getDomain().intValue() == Domain.TOPIC.getId() && dConfig.isDurable()) continue;
                        iter.remove();
                    }
                    factoryConfig.getDestination().addAll(destinationConfigs);
                    return;
                }
            }
        }
    }

    @Override
    public void renameSession(FactoryConfig factoryConfig, String newSessionId) {
        ConnectionConfig connectionConfig = factoryConfig.getConnection().get(0);
        SessionConfig sessionConfig = connectionConfig.getSession().get(0);
        sessionConfig.setId(newSessionId);
    }

    @Override
    public FactoryConfig getFactoryConfig(HermesConfig config, String hermesId) throws HermesException {
        for (FactoryConfig factoryConfig : config.getFactory()) {
            SessionConfig sessionConfig;
            ConnectionConfig connectionConfig = factoryConfig.getConnection().get(0);
            if (connectionConfig.getSession().size() <= 0 || !(sessionConfig = connectionConfig.getSession().get(0)).getId().equals(hermesId)) continue;
            return factoryConfig;
        }
        throw new HermesException("no such session " + hermesId);
    }

    @Override
    public SessionConfig duplicate(SessionConfig sourceSession, String newId) throws JAXBException {
        SessionConfig rval = this.factory.createSessionConfig();
        rval.setAudit(sourceSession.isAudit());
        rval.setAuditDirectory(sourceSession.getAuditDirectory());
        rval.setCheckSize(sourceSession.isCheckSize());
        rval.setCheckSizePeriod(sourceSession.getCheckSizePeriod());
        rval.setId(newId);
        rval.setReconnects(sourceSession.getReconnects());
        rval.setTransacted(sourceSession.isTransacted());
        return rval;
    }

    @Override
    public ConnectionConfig duplicate(ConnectionConfig sourceConnection, String newSessionId) throws JAXBException {
        ConnectionConfig rval = this.factory.createConnectionConfig();
        SessionConfig sessionConfig = sourceConnection.getSession().get(0);
        rval.setPassword(sourceConnection.getPassword());
        rval.setUsername(sourceConnection.getUsername());
        rval.getSession().add(this.duplicate(sessionConfig, newSessionId));
        return rval;
    }

    @Override
    public FactoryConfig duplicate(FactoryConfig sourceFactory, String newSessionId) throws JAXBException {
        FactoryConfig rval = this.factory.createFactoryConfig();
        ConnectionConfig connectionConfig = sourceFactory.getConnection().get(0);
        rval.setClasspathId(sourceFactory.getClasspathId());
        rval.setExtension(sourceFactory.getExtension());
        rval.setProvider(sourceFactory.getProvider());
        rval.getConnection().add(this.duplicate(connectionConfig, newSessionId));
        return rval;
    }

    @Override
    public void duplicateSession(HermesConfig config, String hermesId, String newHermesId) throws JAXBException, HermesException {
        FactoryConfig sourceFactory = this.getFactoryConfig(config, hermesId);
        FactoryConfig newFactory = this.duplicate(sourceFactory, newHermesId);
        newFactory.getDestination().addAll(sourceFactory.getDestination());
        config.getFactory().add(newFactory);
    }
}

