/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.sonicmq;

import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import com.sonicsw.mq.common.runtime.IDurableSubscriptionData;
import com.sonicsw.mq.common.runtime.IQueueData;
import com.sonicsw.mq.mgmtapi.runtime.IBrokerProxy;
import com.sonicsw.mq.mgmtapi.runtime.MQProxyFactory;
import hermes.Domain;
import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.HermesException;
import hermes.JNDIConnectionFactory;
import hermes.browser.HermesBrowser;
import hermes.config.DestinationConfig;
import hermes.ext.HermesAdminSupport;
import hermes.ext.sonicmq.SonicMQAdminFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class SonicMQAdmin
extends HermesAdminSupport
implements HermesAdmin {
    private static final Logger log = Logger.getLogger(SonicMQAdmin.class);
    private SonicMQAdminFactory adminFactory;
    private JMSConnectorClient connector;
    private IBrokerProxy brokerProxy;

    public SonicMQAdmin(Hermes hermes, SonicMQAdminFactory adminFactory) {
        super(hermes);
        this.adminFactory = adminFactory;
    }

    private synchronized IBrokerProxy getBrokerProxy() throws JMSException {
        if (this.brokerProxy == null) {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("ConnectionURLs", this.adminFactory.getConnectionURL());
            env.put("DefaultUser", this.adminFactory.getDefaultUser());
            env.put("DefaultPassword", this.adminFactory.getDefaultPassword());
            JMSConnectorAddress address = new JMSConnectorAddress(env);
            this.connector = new JMSConnectorClient();
            this.connector.connect(address, this.adminFactory.getTimeout());
            try {
                ObjectName jmxName = new ObjectName(this.adminFactory.getDomain() + "." + this.adminFactory.getContainer() + ":ID=" + this.adminFactory.getBrokerName());
                return MQProxyFactory.createBrokerProxy((JMSConnectorClient)this.connector, (ObjectName)jmxName);
            }
            catch (MalformedObjectNameException e) {
                throw new HermesException(e.getMessage(), e);
            }
        }
        return this.brokerProxy;
    }

    @Override
    public synchronized int getDepth(DestinationConfig dConfig) throws JMSException {
        if (dConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
            ArrayList queues = this.getBrokerProxy().getQueues(this.getRealDestinationName(dConfig));
            if (queues.size() > 1) {
                log.warn((Object)("getDepth() for " + dConfig.getName() + " matches " + queues.size() + " queues"));
            }
            if (queues.size() == 0) {
                throw new HermesException("getQueues() for " + dConfig.getName() + " has returned no data");
            }
            IQueueData queueData = (IQueueData)queues.get(0);
            return queueData.getMessageCount();
        }
        if (dConfig.isDurable()) {
            ArrayList durables = this.getBrokerProxy().getDurableSubscriptions(this.getRealDestinationName(dConfig));
            for (IDurableSubscriptionData data : durables) {
                if ((data.getClientID() != null || this.getHermes().getConnection().getClientID() != null) && !data.getClientID().equals(this.getHermes().getConnection().getClientID()) || !data.getSubscriptionName().equals(dConfig.getClientID())) continue;
                return (int)data.getMessageCount();
            }
            throw new HermesException("Durable subscription " + dConfig.getClientID() + " on topic " + dConfig.getName() + " cannot be found");
        }
        throw new HermesException("SonicMQ cannot give the depth of a non-durable topic");
    }

    @Override
    public synchronized void close() throws JMSException {
        if (this.brokerProxy != null) {
            this.brokerProxy.stop();
            this.brokerProxy = null;
        }
        if (this.connector != null) {
            this.connector.disconnect();
            this.connector = null;
        }
    }

    @Override
    public synchronized Collection discoverDestinationConfigs() throws JMSException {
        if (this.getHermes().getConnectionFactory() instanceof JNDIConnectionFactory) {
            return super.discoverDestinationConfigs();
        }
        try {
            ArrayList<DestinationConfig> rval = new ArrayList<DestinationConfig>();
            for (IQueueData queueData : this.getBrokerProxy().getQueues(null)) {
                DestinationConfig dConfig = HermesBrowser.getConfigDAO().createDestinationConfig();
                dConfig.setName(queueData.getQueueName());
                dConfig.setDomain(Domain.QUEUE.getId());
                rval.add(dConfig);
            }
            return rval;
        }
        catch (JMSException e) {
            this.brokerProxy = null;
            throw e;
        }
    }

    @Override
    public int truncate(DestinationConfig dConfig) throws JMSException {
        if (dConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
            try {
                int rval = this.getDepth(dConfig);
                ArrayList<String> queues = new ArrayList<String>();
                queues.add(this.getRealDestinationName(dConfig));
                this.getBrokerProxy().deleteQueueMessages(queues);
                return rval;
            }
            catch (JMSException e) {
                this.brokerProxy = null;
                throw e;
            }
        }
        throw new HermesException("SonicMQ does not support truncating topic subscriptions");
    }
}

