/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.transferable;

import hermes.Domain;
import hermes.HermesException;
import hermes.HermesRuntimeException;
import hermes.browser.HermesBrowser;
import hermes.browser.actions.BrowserAction;
import hermes.browser.components.BrowserTree;
import hermes.browser.components.MessageHeaderTable;
import hermes.browser.transferable.JMSMessagesTransferable;
import hermes.browser.transferable.MessageGroup;
import hermes.swing.actions.ActionRegistry;
import hermes.swing.actions.CopyMessagesToClipboardAction;
import hermes.swing.actions.CutMessagesToClipboardAction;
import hermes.swing.actions.PasteMessagesFromClipboardAction;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.apache.log4j.Logger;

public class MessageHeaderTransferHandler
extends TransferHandler {
    private static final Logger log = Logger.getLogger(MessageHeaderTransferHandler.class);
    private BrowserAction action;

    public static Action getCutAction() {
        return ActionRegistry.getAction(CutMessagesToClipboardAction.class);
    }

    public static Action getCopyAction() {
        return ActionRegistry.getAction(CopyMessagesToClipboardAction.class);
    }

    public static Action getPasteAction() {
        return ActionRegistry.getAction(PasteMessagesFromClipboardAction.class);
    }

    public MessageHeaderTransferHandler(BrowserAction action) {
        this.action = action;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        return new JMSMessagesTransferable(new MessageGroup(this.action.getHermes(), this.action.getSelectedMessages()));
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        super.exportAsDrag(comp, e, action);
    }

    @Override
    public int getSourceActions(JComponent c) {
        if (c instanceof MessageHeaderTable) {
            return 3;
        }
        return 0;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        if (comp instanceof BrowserTree) {
            return ((BrowserTree)comp).isCurrentSelectionADestination();
        }
        return false;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        if (comp instanceof BrowserTree) {
            BrowserTree browserTree = (BrowserTree)comp;
            return browserTree.doTransfer(t, 1);
        }
        return false;
    }

    @Override
    protected void exportDone(JComponent comp, Transferable data, int dndAction) {
        try {
            if (HermesBrowser.getBrowser().getConfig().isCorrectDropSemantics() && this.action.getDomain() == Domain.QUEUE) {
                HermesBrowser.getBrowser().getBrowserTree().setLastDnDAction(dndAction);
            } else {
                HermesBrowser.getBrowser().getBrowserTree().setLastDnDAction(1);
            }
        }
        catch (HermesException e) {
            throw new HermesRuntimeException(e.getLinkedException());
        }
    }
}

