/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.model.tree;

import hermes.Domain;
import hermes.Hermes;
import hermes.HermesException;
import hermes.JNDIContextFactory;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.model.tree.AbstractTreeNode;
import hermes.browser.model.tree.ConnectionFactoryTreeNode;
import hermes.browser.model.tree.ExceptionTreeNode;
import hermes.browser.model.tree.QueueTopicTreeNode;
import hermes.browser.model.tree.QueueTreeNode;
import hermes.browser.model.tree.TopicTreeNode;
import hermes.browser.model.tree.UnknownTreeNode;
import hermes.config.NamingConfig;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.apache.log4j.Logger;

public class ContextTreeNode
extends AbstractTreeNode {
    private static final Logger log = Logger.getLogger(ContextTreeNode.class);
    private NamingConfig config;
    private boolean isNameInNamespaceCheck = true;

    private ContextTreeNode(Set<String> visited, String id, NamingConfig config, Context context) throws HermesException {
        super(id, context);
        this.config = config;
        this.setIcon(IconCache.getIcon("hermes.tree.folder.opened"));
        this.setContext(visited, context);
    }

    public ContextTreeNode(String id, NamingConfig config, Context context) throws HermesException {
        this(new HashSet<String>(), id, config, context);
    }

    public NamingConfig getConfig() {
        return this.config;
    }

    public JNDIContextFactory getContextFactory() throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        return new JNDIContextFactory(this.config);
    }

    private void setContext(Set<String> visited, Context context) throws HermesException {
        try {
            Hermes.ui.getDefaultMessageSink().add("Searching context " + this.getId() + "...");
            log.debug((Object)("Searching context " + this.getId() + "..."));
            try {
                visited.add(context.getNameInNamespace());
            }
            catch (OperationNotSupportedException ex) {
                this.isNameInNamespaceCheck = false;
            }
            NamingEnumeration<NameClassPair> iter = context.list("");
            while (iter.hasMore()) {
                NameClassPair entry = iter.next();
                AbstractTreeNode child = null;
                try {
                    Object object = context.lookup(entry.getName());
                    log.debug((Object)("found " + entry.getClassName() + " bound at " + entry.getName()));
                    if (object instanceof Destination) {
                        Domain domain = Domain.getDomain((Destination)object);
                        child = domain == Domain.TOPIC ? new TopicTreeNode(entry.getName(), (Topic)object) : (domain == Domain.QUEUE ? new QueueTreeNode(entry.getName(), (Queue)object) : new QueueTopicTreeNode(entry.getName(), (Destination)object));
                    } else if (object instanceof ConnectionFactory) {
                        child = new ConnectionFactoryTreeNode(entry.getName(), (ConnectionFactory)object);
                    } else if (object instanceof Context) {
                        if (this.isNameInNamespaceCheck && visited.contains(((Context)object).getNameInNamespace())) {
                            log.debug((Object)("skipping already visited context " + this.getId()));
                        } else {
                            child = new ContextTreeNode(visited, entry.getName(), this.config, (Context)object);
                        }
                    } else {
                        child = new UnknownTreeNode(entry.getName(), object);
                    }
                }
                catch (Throwable ex) {
                    child = new ExceptionTreeNode(entry.getName(), ex);
                }
                if (child == null) continue;
                this.add(child);
            }
        }
        catch (NamingException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            if (ex.getCause() != null) {
                Hermes.ui.getDefaultMessageSink().add(ex.getCause().getMessage());
            } else {
                Hermes.ui.getDefaultMessageSink().add(ex.getMessage());
            }
            throw new HermesException(ex);
        }
        finally {
            try {
                context.close();
            }
            catch (Throwable e) {
                HermesBrowser.getBrowser().showErrorDialog(e.getClass().getName() + " thrown when closing the Context", e);
            }
        }
    }
}

