/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.actions;

import hermes.Domain;
import hermes.Hermes;
import hermes.HermesRepository;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.actions.QueueBrowseAction;
import hermes.browser.tasks.BrowseRepositoryFileTask;
import hermes.browser.tasks.Task;
import javax.jms.JMSException;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class RepositoryFileBrowserAction
extends QueueBrowseAction {
    private static final Logger log = Logger.getLogger(RepositoryFileBrowserAction.class);
    private HermesRepository repository;

    public RepositoryFileBrowserAction(Hermes hermes, HermesRepository repository, int maxMessages) throws JMSException {
        super(hermes, HermesBrowser.getConfigDAO().createDestinationConfig(repository.getId(), Domain.QUEUE), maxMessages, null);
        this.repository = repository;
    }

    public RepositoryFileBrowserAction(HermesRepository repository, int maxMessages) throws JMSException {
        super(null, HermesBrowser.getConfigDAO().createDestinationConfig(repository.getId(), Domain.QUEUE), maxMessages, null);
        this.repository = repository;
    }

    @Override
    public boolean isRefreshable() {
        return false;
    }

    @Override
    protected Task createTask() throws Exception {
        return new BrowseRepositoryFileTask(this.getHermes(), this.repository);
    }

    @Override
    public Icon getIcon() {
        return IconCache.getIcon("hermes.file.xml");
    }
}

