/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.actions;

import com.codestreet.selector.parser.InvalidSelectorException;
import com.jidesoft.document.DocumentComponentEvent;
import com.jidesoft.document.DocumentComponentListener;
import com.jidesoft.swing.JideScrollPane;
import hermes.Domain;
import hermes.Hermes;
import hermes.HermesException;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.actions.AbstractDocumentComponent;
import hermes.browser.actions.FilterableAction;
import hermes.browser.components.HierarchicalMessageHeaderTable;
import hermes.browser.components.MessageHeaderTable;
import hermes.browser.components.MessagePayloadPanel;
import hermes.browser.components.MessagesDeleteable;
import hermes.browser.components.NavigableComponent;
import hermes.browser.components.PopupMenuFactory;
import hermes.browser.model.MessageHeaderTableModel;
import hermes.browser.tasks.MessageTaskListener;
import hermes.browser.tasks.Task;
import hermes.config.DestinationConfig;
import hermes.swing.FilterablePanel;
import hermes.swing.SQL92FilterableTableModel;
import hermes.swing.SwingRunner;
import hermes.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public abstract class BrowserAction
extends AbstractDocumentComponent
implements ListSelectionListener,
DocumentComponentListener,
MessageTaskListener,
FilterableAction,
NavigableComponent,
MessagesDeleteable {
    private static final Logger log = Logger.getLogger(BrowserAction.class);
    private static final Icon queueIcon = IconCache.getIcon("hermes/browser/icons/queue.gif");
    private static final Timer timer = new Timer();
    private static final Icon topicIcon = IconCache.getIcon("hermes/browser/icons/topic.gif");
    private final List<Message> cachedRows = new ArrayList<Message>();
    private final JLabel statusMessage = new JLabel();
    private boolean firstMessage = true;
    private Hermes hermes;
    private long lastMessagePerSecond = 0L;
    private long lastMessagesRead = 0L;
    private ListSelectionEvent lastSelected;
    private int maxMessages = 1000;
    private long maxMessagesPerSecond = 0L;
    private final MessageHeaderTable messageHeaderTable;
    private final MessageHeaderTableModel messageHeaderTableModel;
    private SQL92FilterableTableModel filterModel;
    private final MessagePayloadPanel messagePayloadPanel;
    private JPopupMenu popup;
    private JideScrollPane headerScrollPane;
    private TimerTask rateTask;
    private int readMessages = 0;
    private int screenUpdateTimeout = 100;
    private JPanel statusPanel;
    private Task task;
    private JPanel topPanel;
    private long totalMessagesRead = 0L;
    private TimerTask uiUpdateTimer;
    private TimerTask autoBrowseTimer;
    private boolean autoBrowse = false;
    private int selectedRow = -1;
    private boolean taskStopped = false;
    private DestinationConfig dConfig;
    private String postfix;

    public static String getDisplayName(Hermes hermes, DestinationConfig config, String postfix) {
        String rval = null;
        rval = hermes != null ? hermes.getId() + " " + config.getName() + " " + (config.getSelector() != null ? config.getSelector() : "") + (config.isDurable() ? " name=" + config.getClientID() : "") : config.getName() + " " + (config.getSelector() != null ? config.getSelector() : "") + (config.isDurable() ? " name=" + config.getClientID() : "");
        return postfix == null ? rval : rval + " for " + postfix;
    }

    public BrowserAction(Hermes hermes, DestinationConfig dConfig, int maxMessages, String postfix) throws JMSException {
        super(new JPanel(), BrowserAction.getDisplayName(hermes, dConfig, postfix));
        this.dConfig = dConfig;
        this.messageHeaderTableModel = new MessageHeaderTableModel(hermes, dConfig.getName());
        this.messageHeaderTable = new MessageHeaderTable(hermes, this, this.messageHeaderTableModel);
        this.hermes = hermes;
        this.maxMessages = maxMessages;
        this.messagePayloadPanel = new MessagePayloadPanel(dConfig.getName());
        this.postfix = postfix;
        this.topPanel = (JPanel)this.getComponent();
    }

    public DestinationConfig getDestinationConfig() {
        return this.dConfig;
    }

    public String getName() {
        if (this.dConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
            return "Q " + super.getName();
        }
        return "T " + super.getName();
    }

    @Override
    public ListSelectionModel getListSelectionModel() {
        return this.messageHeaderTable.getSelectionModel();
    }

    @Override
    public boolean isNavigableForward() {
        return this.getMessageHeaderTable().getSelectedRow() < this.getMessageHeaderTable().getRowCount() - 1;
    }

    @Override
    public boolean isNavigableBackward() {
        return this.getMessageHeaderTable().getSelectedRow() > 0 && this.getMessageHeaderTable().getRowCount() > 1;
    }

    @Override
    public void navigateBackward() {
        this.decrementSelection();
    }

    @Override
    public void navigateForward() {
        this.incrementSelection();
    }

    public String getTitle() {
        return BrowserAction.getDisplayName(this.hermes, this.dConfig, this.postfix);
    }

    public DestinationConfig getConfig() {
        return this.dConfig;
    }

    public String getSelector() {
        return this.dConfig.getSelector();
    }

    public Domain getDomain() {
        return Domain.getDomain(this.dConfig.getDomain());
    }

    public boolean isRunning() {
        return !this.taskStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMessage(Message message) throws JMSException {
        List<Message> list = this.cachedRows;
        synchronized (list) {
            this.cachedRows.add(message);
            ++this.totalMessagesRead;
        }
    }

    protected abstract Task createTask() throws Exception;

    public void documentComponentMoved(DocumentComponentEvent arg0) {
    }

    public void documentComponentMoving(DocumentComponentEvent arg0) {
    }

    public void documentComponentActivated(DocumentComponentEvent arg0) {
    }

    public void documentComponentClosed(DocumentComponentEvent arg0) {
        log.debug((Object)("documentClosed " + this.getName()));
        this.messageHeaderTableModel.clear();
        if (this.task != null) {
            this.task.stop();
        }
        if (this.autoBrowseTimer != null) {
            this.autoBrowseTimer.cancel();
        }
        this.autoBrowse = false;
    }

    public void documentComponentClosing(DocumentComponentEvent arg0) {
    }

    public void documentComponentDeactivated(DocumentComponentEvent arg0) {
    }

    public void documentComponentOpened(DocumentComponentEvent arg0) {
    }

    public void decrementSelection() {
        int currentRow = this.getMessageHeaderTable().getSelectedRow();
        this.getMessageHeaderTable().getSelectionModel().setSelectionInterval(currentRow - 1, currentRow - 1);
    }

    public void incrementSelection() {
        int currentRow = this.getMessageHeaderTable().getSelectedRow();
        this.getMessageHeaderTable().getSelectionModel().setSelectionInterval(currentRow + 1, currentRow + 1);
    }

    public void enrichPopup(JPopupMenu popupMenu) {
    }

    public void doPopup(MouseEvent e) {
        if (this.popup == null) {
            this.popup = PopupMenuFactory.createBrowseActionPopup();
            this.enrichPopup(this.popup);
        }
        this.popup.show((Component)((Object)this.messageHeaderTable), e.getX(), e.getY());
    }

    public String getDestination() {
        return this.dConfig.getName();
    }

    public Hermes getHermes() {
        return this.hermes;
    }

    public Icon getIcon() {
        if (this.dConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
            return queueIcon;
        }
        if (this.dConfig.isDurable()) {
            return IconCache.getIcon("jms.durableTopic");
        }
        return topicIcon;
    }

    public MessageHeaderTable getMessageHeaderTable() {
        return this.messageHeaderTable;
    }

    public Set<String> getSelectedMessageIDs() throws JMSException {
        HashSet<String> ids = new HashSet<String>();
        int[] rows = this.messageHeaderTable.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            Message m = this.messageHeaderTableModel.getMessageAt(this.filterModel.getActualRowAt(rows[i]));
            if (m.getJMSMessageID() == null) {
                throw new HermesException("One or more of the messages has a null JMSMessageID");
            }
            try {
                ids.add(m.getJMSMessageID());
                continue;
            }
            catch (Exception ex) {
                log.error((Object)("calling getJMSMessageID() on message " + m + ": " + ex.getMessage()), (Throwable)ex);
            }
        }
        return ids;
    }

    public boolean hasSelection() {
        return this.messageHeaderTable.getSelectedRowCount() > 0;
    }

    public Collection<Message> getSelectedMessages() {
        ArrayList<Message> ids = new ArrayList<Message>();
        int[] rows = this.messageHeaderTable.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            Message m = this.messageHeaderTableModel.getMessageAt(this.filterModel.getActualRowAt(rows[i]));
            try {
                ids.add(m);
                continue;
            }
            catch (Exception ex) {
                log.error((Object)("calling getJMSMessageID() on message " + m + ": " + ex.getMessage()), (Throwable)ex);
            }
        }
        return ids;
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusPanel = new JPanel();
            this.statusPanel.setLayout(new BorderLayout());
            this.statusPanel.setAlignmentY(1.0f);
            this.statusMessage.setText("Connecting...");
            this.statusMessage.setBorder(new EtchedBorder());
            this.statusPanel.add(this.statusMessage);
        }
        return this.statusPanel;
    }

    public String getTooltip() {
        return this.getTitle();
    }

    public void init() throws JMSException {
        this.initUI();
        this.refresh();
    }

    private void initUI() throws JMSException {
        this.headerScrollPane = new JideScrollPane();
        this.filterModel = new SQL92FilterableTableModel(this.messageHeaderTableModel);
        this.filterModel.setRowValueProvider(this.messageHeaderTableModel);
        this.messageHeaderTable.setModel((TableModel)((Object)this.filterModel));
        this.topPanel.setLayout(new BorderLayout());
        if (HermesBrowser.getBrowser().getConfig().isEmbeddedMessageInBrowsePane()) {
            this.topPanel.add((Component)this.headerScrollPane, "Center");
            HierarchicalMessageHeaderTable hTable = new HierarchicalMessageHeaderTable(this, this.messageHeaderTableModel);
            this.headerScrollPane.setViewportView((Component)((Object)hTable));
            hTable.setSelectionMode(2);
            hTable.setSingleExpansion(false);
        } else {
            this.headerScrollPane.setViewportView((Component)((Object)this.messageHeaderTable));
            JSplitPane splitPane = new JSplitPane(0);
            splitPane.setDividerLocation(200);
            splitPane.setOneTouchExpandable(false);
            splitPane.setContinuousLayout(true);
            splitPane.add((Component)this.headerScrollPane, "top");
            splitPane.add((Component)this.messagePayloadPanel, "bottom");
            this.topPanel.add((Component)splitPane, "Center");
            this.messageHeaderTable.getSelectionModel().addListSelectionListener(this);
        }
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)new FilterablePanel(), "North");
        bottomPanel.add((Component)this.getStatusPanel(), "South");
        this.topPanel.add((Component)bottomPanel, "South");
        HermesBrowser.getBrowser().addDocumentComponent(this);
        this.addDocumentComponentListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Task task, Message message) {
        List<Message> list = this.cachedRows;
        synchronized (list) {
            this.cachedRows.add(message);
            ++this.totalMessagesRead;
        }
    }

    @Override
    public void onStarted(Task task) {
    }

    @Override
    public void onStatus(Task task, final String status) {
        SwingRunner.invokeLater(new Runnable(){

            @Override
            public void run() {
                BrowserAction.this.statusMessage.setText(status);
            }
        });
    }

    public abstract boolean isRefreshable();

    @Override
    public void onStopped(Task task) {
        try {
            this.updateTableRows();
            this.taskStopped = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BrowserAction.this.messageHeaderTableModel.setFinalMessageIndex(BrowserAction.this.readMessages - 1);
                    if (BrowserAction.this.selectedRow >= 0) {
                        BrowserAction.this.messageHeaderTable.getSelectionModel().setSelectionInterval(BrowserAction.this.selectedRow, BrowserAction.this.selectedRow);
                        BrowserAction.this.valueChanged(null);
                    }
                }
            });
            if (this.autoBrowse && this.isRefreshable()) {
                this.autoBrowseTimer = new TimerTask(){

                    @Override
                    public void run() {
                        BrowserAction.this.refresh();
                    }
                };
                log.debug((Object)("scheduling browser refresh for " + this.getDestination() + " on session " + this.getHermes().getId() + " in " + HermesBrowser.getBrowser().getConfig().getAutoBrowseRefreshRate() + "s"));
                timer.schedule(this.autoBrowseTimer, HermesBrowser.getBrowser().getConfig().getAutoBrowseRefreshRate() * 1000);
            }
        }
        catch (HermesException e) {
            log.error((Object)e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    public TableModel getTableModel() {
        return this.getMessageHeaderTable().getModel();
    }

    @Override
    public boolean isDeleteable() {
        return this.hasSelection();
    }

    public boolean isAutoBrowse() {
        return this.autoBrowse;
    }

    public void setAutoBrowse(boolean autoBrowse) {
        this.autoBrowse = autoBrowse;
        if (autoBrowse) {
            if (this.taskStopped) {
                this.refresh();
            }
        } else if (this.autoBrowseTimer != null) {
            this.autoBrowseTimer.cancel();
        }
    }

    @Override
    public void onThrowable(Task task, final Throwable t) {
        SwingRunner.invokeLater(new Runnable(){

            @Override
            public void run() {
                BrowserAction.this.statusMessage.setText(t.getMessage());
            }
        });
    }

    public void refresh() {
        this.readMessages = 0;
        this.maxMessagesPerSecond = 0L;
        this.lastMessagePerSecond = 0L;
        this.lastMessagesRead = 0L;
        this.cachedRows.clear();
        if (this.task != null) {
            this.task.stop();
        }
        if (this.rateTask != null) {
            this.rateTask.cancel();
        }
        if (this.uiUpdateTimer != null) {
            this.uiUpdateTimer.cancel();
        }
        this.uiUpdateTimer = new TimerTask(){

            @Override
            public void run() {
                BrowserAction.this.updateTableRows();
                if (BrowserAction.this.task != null && !BrowserAction.this.task.isRunning()) {
                    this.cancel();
                }
            }
        };
        timer.schedule(this.uiUpdateTimer, this.screenUpdateTimeout, (long)this.screenUpdateTimeout);
        this.rateTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = BrowserAction.this.cachedRows;
                synchronized (list) {
                    BrowserAction.this.lastMessagePerSecond = BrowserAction.this.totalMessagesRead - BrowserAction.this.lastMessagesRead;
                    if (BrowserAction.this.lastMessagePerSecond > BrowserAction.this.maxMessagesPerSecond) {
                        BrowserAction.this.maxMessagesPerSecond = BrowserAction.this.lastMessagePerSecond;
                    }
                    BrowserAction.this.lastMessagesRead = BrowserAction.this.totalMessagesRead;
                }
                if (BrowserAction.this.task != null && BrowserAction.this.task.isRunning()) {
                    this.cancel();
                }
            }
        };
        timer.schedule(this.rateTask, 1000L, 1000L);
        try {
            this.taskStopped = false;
            this.task = this.createTask();
            this.task.addTaskListener(this);
            this.task.start();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setDestinationName(String destinationName) {
        this.messageHeaderTableModel.setDestinationName(destinationName);
    }

    public void setStatusText(String text) {
        this.statusMessage.setText(text);
    }

    public String toShortString() throws JMSException {
        return this.hermes.getMetaData().getShortName() + ": " + this.getDestination();
    }

    public String toString() {
        try {
            return "browse " + this.toShortString();
        }
        catch (JMSException ex) {
            return super.toString();
        }
    }

    public void updateTableRows() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = BrowserAction.this.cachedRows;
                    synchronized (list) {
                        Iterator iter = BrowserAction.this.cachedRows.iterator();
                        while (iter.hasNext()) {
                            try {
                                BrowserAction.this.messageHeaderTableModel.addMessage(BrowserAction.this.readMessages++, (Message)iter.next());
                                if (!BrowserAction.this.firstMessage) continue;
                                BrowserAction.this.messageHeaderTable.getSelectionModel().setSelectionInterval(0, 0);
                                BrowserAction.this.firstMessage = false;
                            }
                            catch (JMSException e) {
                                log.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                        boolean autoScroll = BrowserAction.this.cachedRows.size() > 0;
                        BrowserAction.this.cachedRows.clear();
                        while (BrowserAction.this.maxMessages > 0 && BrowserAction.this.messageHeaderTableModel.getRowCount() > BrowserAction.this.maxMessages) {
                            BrowserAction.this.messageHeaderTableModel.removeFirstRow();
                        }
                        try {
                            if (autoScroll && HermesBrowser.getBrowser().getConfig().isScrollMessagesDuringBrowse()) {
                                SwingUtils.scrollVertically((JComponent)((Object)BrowserAction.this.messageHeaderTable), SwingUtils.getRowBounds((JTable)((Object)BrowserAction.this.messageHeaderTable), BrowserAction.this.messageHeaderTableModel.getRowCount(), BrowserAction.this.messageHeaderTableModel.getRowCount()));
                            }
                        }
                        catch (HermesException ex) {
                            log.error((Object)ex.getMessage(), (Throwable)((Object)ex));
                        }
                    }
                    StringBuffer buffer = new StringBuffer();
                    if (BrowserAction.this.task != null && !BrowserAction.this.task.isRunning()) {
                        buffer.append("Finished. ");
                    }
                    switch (BrowserAction.this.messageHeaderTableModel.getRowCount()) {
                        case 0: {
                            buffer.append("No messages read.");
                            break;
                        }
                        case 1: {
                            buffer.append("1 message read.");
                            break;
                        }
                        default: {
                            buffer.append(BrowserAction.this.readMessages).append(" messages read.");
                        }
                    }
                    if (BrowserAction.this.readMessages > BrowserAction.this.maxMessages) {
                        // empty if block
                    }
                    if (BrowserAction.this.task != null && !BrowserAction.this.task.isRunning() || BrowserAction.this.messageHeaderTableModel.getRowCount() > 0) {
                        BrowserAction.this.statusMessage.setText(buffer.toString());
                    }
                }
            });
        }
        catch (InterruptedException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.selectedRow = this.filterModel.getActualRowAt(this.messageHeaderTable.getSelectedRow());
        if (this.messageHeaderTableModel.getRowCount() > this.selectedRow && this.selectedRow >= 0) {
            int row = this.selectedRow;
            Message m = this.messageHeaderTableModel.getMessageAt(row);
            this.messageHeaderTable.scrollRectToVisible(this.messageHeaderTable.getCellRect(this.selectedRow, 0, true));
            if (m != null) {
                this.messagePayloadPanel.setMessage(this.hermes, m);
            }
        }
    }

    public void documentComponentDocked(DocumentComponentEvent arg0) {
    }

    public void documentComponentFloated(DocumentComponentEvent arg0) {
    }

    @Override
    public void delete() {
        try {
            HermesBrowser.getBrowser().getActionFactory().createTruncateAction(this.hermes, this.getConfig(), this.getSelectedMessageIDs(), true);
        }
        catch (JMSException ex) {
            HermesBrowser.getBrowser().showErrorDialog(ex);
        }
    }

    @Override
    public void setSelector(String selector) throws InvalidSelectorException {
        this.filterModel.setSelector(selector);
    }
}

