/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.Util;
import com.install4j.api.actions.AbstractInstallAction;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.files.AbstractRecursiveFileAction;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;

public class SetModeAction
extends AbstractRecursiveFileAction {
    private String mode;
    private boolean recursive;

    public String getMode() {
        return SetModeAction.replaceVariables(this.mode);
    }

    public void setMode(String string) {
        this.mode = string;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    public boolean execute(Context context) throws UserCanceledException {
        if (InstallerUtil.isWindows()) {
            return true;
        }
        String string = this.getMode();
        if (string == null || string.trim().length() == 0) {
            Logger.getInstance().log(this, "Mode is not set", false);
            return false;
        }
        return super.execute(context);
    }

    protected boolean executeForSingleRecursiveFile(Context context, File file, File file2, ProgressAdapter progressAdapter) throws UserCanceledException, IOException {
        UnixFileSystem.FileInformation fileInformation = UnixFileSystem.getFileInformation(file);
        if (fileInformation != null && fileInformation.getMode() > -1) {
            this.addRollbackAction(new PerformedAction(fileInformation.getMode(), file));
        }
        Util.logInfo(this, "Setting mode for " + file.getAbsolutePath());
        return UnixFileSystem.setMode(this.getMode(), file);
    }

    private static class PerformedAction
    extends AbstractInstallAction {
        private int oldMode;
        private File file;

        public PerformedAction(int n, File file) {
            this.oldMode = n;
            this.file = file;
        }

        public boolean install(InstallerContext installerContext) throws UserCanceledException {
            throw new UnsupportedOperationException();
        }

        public void rollback(InstallerContext installerContext) {
            UnixFileSystem.setMode(this.oldMode, this.file);
        }
    }
}

