/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;

public abstract class AbstractModifyFileAction
extends SystemInstallOrUninstallAction {
    protected abstract boolean modifyFile(File var1, Context var2) throws IOException, UserCanceledException;

    protected boolean executeForSingleFile(Context context, File file) throws UserCanceledException {
        File file2 = context.getDestinationFile(file);
        try {
            if (this.fileMustExist() && !file2.exists()) {
                Logger.getInstance().error(this, "The file " + file2.getAbsolutePath() + " does not exist.");
                return false;
            }
            if (context instanceof InstallerContext) {
                if (this.fileWillBeCreated() && !file2.exists()) {
                    BackupFileForRollbackAction backupFileForRollbackAction = new BackupFileForRollbackAction(file2, true);
                    backupFileForRollbackAction.install((InstallerContext)context);
                    this.addRollbackAction(backupFileForRollbackAction);
                } else if (file2.isFile()) {
                    BackupFileForRollbackAction backupFileForRollbackAction = new BackupFileForRollbackAction(file2, false);
                    backupFileForRollbackAction.install((InstallerContext)context);
                    this.addRollbackAction(backupFileForRollbackAction);
                }
            }
            return this.modifyFile(file2, context);
        }
        catch (IOException iOException) {
            Logger.getInstance().log(iOException);
            return false;
        }
    }

    protected boolean executeForMultipleFiles(Context context, File[] fileArray) throws UserCanceledException {
        if (fileArray == null) {
            return true;
        }
        boolean bl = true;
        for (int i = 0; i < fileArray.length; ++i) {
            bl &= this.executeForSingleFile(context, fileArray[i]);
        }
        return bl;
    }

    protected boolean fileMustExist() {
        return false;
    }

    protected boolean fileWillBeCreated() {
        return false;
    }

    protected Object maybeFilterLogReplacement(String string, String string2, Object object, boolean bl) {
        if (string.equals(string2) && !bl) {
            return "[logging of replacement text is disabled]";
        }
        return object;
    }
}

