/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wsi.test.validator.Configuration;
import org.wsi.test.validator.EntryResult;
import org.wsi.test.validator.ValidatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactResult {
    private List<EntryResult> entryResults = new ArrayList<EntryResult>();
    private String type;

    public ArtifactResult(String t) {
        this.type = t;
    }

    protected String getType() {
        return this.type;
    }

    public void addEntryResult(EntryResult r) {
        this.entryResults.add(r);
    }

    public List<EntryResult> getEntryResults() {
        return this.entryResults;
    }

    public boolean anyFailed(String id) {
        for (EntryResult e : this.entryResults) {
            if (!e.anyFailed(id)) continue;
            return true;
        }
        return false;
    }

    public boolean anyWarnings(String id) {
        for (EntryResult e : this.entryResults) {
            if (!e.anyWarnings(id)) continue;
            return true;
        }
        return false;
    }

    public boolean anyPassed(String id) {
        for (EntryResult e : this.entryResults) {
            if (!e.anyPassed(id)) continue;
            return true;
        }
        return false;
    }

    public boolean allNotApplicable(String id) {
        for (EntryResult e : this.entryResults) {
            if (e.allNotApplicable(id)) continue;
            return false;
        }
        return true;
    }

    public boolean anyNotApplicable(String id) {
        for (EntryResult e : this.entryResults) {
            if (!e.anyNotApplicable(id)) continue;
            return true;
        }
        return false;
    }

    public List<String> getReportedIds() {
        HashSet<String> ids = new HashSet<String>();
        for (EntryResult r : this.entryResults) {
            ids.addAll(r.getReportedIds());
        }
        return new ArrayList<String>(ids);
    }

    public Element getReportElement(Document doc, String reportNamespace, Configuration config) throws ValidatorException {
        Element result = doc.createElementNS(reportNamespace, "artifact");
        result.setAttribute("type", this.getType());
        for (EntryResult r : this.getEntryResults()) {
            result.appendChild(r.getReportElement(doc, reportNamespace, config));
        }
        return result;
    }
}

