/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wsi.test.validator.ArtifactResult;
import org.wsi.test.validator.Assertion;
import org.wsi.test.validator.Configuration;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.service.ProfileService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Artifact {
    private List<Assertion> assertions;
    private String type;

    public Artifact(Element el, ProfileService profile) throws ValidatorException {
        NodeList assertionNL = el.getElementsByTagNameNS("http://www.ws-i.org/testing/2004/07/assertions/", "testAssertion");
        this.assertions = new ArrayList<Assertion>();
        int i = 0;
        while (i < assertionNL.getLength()) {
            Assertion newAssertion;
            Element assertionEl = (Element)assertionNL.item(i);
            if (!assertionEl.getAttribute("enabled").equals("false") && (newAssertion = profile.getAssertion(assertionEl)) != null) {
                this.assertions.add(newAssertion);
            }
            ++i;
        }
        this.type = el.getAttribute("type");
    }

    public String getType() {
        return this.type;
    }

    public abstract ArtifactResult validate(Configuration var1) throws ValidatorException;

    public List<Assertion> getAssertions() {
        return this.assertions;
    }
}

