/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.analytics;

import com.eviware.soapui.analytics.AnalyticsManager;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActionDescription {
    private final String sessionId;
    private final AnalyticsManager.Category category;
    private final String actionName;
    private Map<String, String> params;

    public ActionDescription(String sessionId, AnalyticsManager.Category category, String actionName, Map<String, String> params) {
        this.sessionId = sessionId;
        this.category = category;
        this.actionName = actionName;
        this.params = params;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public AnalyticsManager.Category getCategory() {
        return this.category;
    }

    public String getActionName() {
        return this.actionName;
    }

    public String getParamsAsString() {
        if (this.params != null) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(entry.getKey()).append(": ").append(entry.getValue());
            }
            return sb.toString();
        }
        return "";
    }

    public String toString() {
        return String.format("Action: %s, Additional data: %s, params: [%s]", this.category.toString(), this.getActionName(), this.getParamsAsString());
    }

    public static final String getUserId() throws UnknownHostException, SocketException {
        NetworkInterface network = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
        byte[] mac = network.getHardwareAddress();
        StringBuilder sb = new StringBuilder();
        for (byte aMac : mac) {
            sb.append(String.format("%d", aMac));
        }
        return sb.toString();
    }
}

