/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.localserver;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.DefaultHttpServerConnection;
import org.apache.http.localserver.EchoHandler;
import org.apache.http.localserver.RandomHandler;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpExpectationVerifier;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerRegistry;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;

public class LocalTestServer {
    public static final InetSocketAddress TEST_SERVER_ADDR = new InetSocketAddress("127.0.0.1", 0);
    private final HttpRequestHandlerRegistry handlerRegistry;
    private final HttpService httpservice;
    private final SSLContext sslcontext;
    private volatile ServerSocket servicedSocket;
    private volatile ListenerThread listenerThread;
    private final Set<Worker> workers;
    private final AtomicInteger acceptedConnections = new AtomicInteger(0);

    public LocalTestServer(BasicHttpProcessor proc, ConnectionReuseStrategy reuseStrat, HttpResponseFactory responseFactory, HttpExpectationVerifier expectationVerifier, HttpParams params, SSLContext sslcontext) {
        this.handlerRegistry = new HttpRequestHandlerRegistry();
        this.workers = Collections.synchronizedSet(new HashSet());
        this.httpservice = new HttpService((HttpProcessor)(proc != null ? proc : this.newProcessor()), reuseStrat != null ? reuseStrat : this.newConnectionReuseStrategy(), responseFactory != null ? responseFactory : this.newHttpResponseFactory(), (HttpRequestHandlerResolver)this.handlerRegistry, expectationVerifier, params != null ? params : this.newDefaultParams());
        this.sslcontext = sslcontext;
    }

    public LocalTestServer(SSLContext sslcontext) {
        this(null, null, null, null, null, sslcontext);
    }

    public LocalTestServer(BasicHttpProcessor proc, HttpParams params) {
        this(proc, null, null, null, params, null);
    }

    protected HttpProcessor newProcessor() {
        return new ImmutableHttpProcessor(new HttpResponseInterceptor[]{new ResponseDate(), new ResponseServer(), new ResponseContent(), new ResponseConnControl()});
    }

    protected HttpParams newDefaultParams() {
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        params.setIntParameter("http.socket.timeout", 60000).setIntParameter("http.socket.buffer-size", 8192).setBooleanParameter("http.connection.stalecheck", false).setBooleanParameter("http.tcp.nodelay", true).setParameter("http.origin-server", (Object)"LocalTestServer/1.1");
        return params;
    }

    protected ConnectionReuseStrategy newConnectionReuseStrategy() {
        return new DefaultConnectionReuseStrategy();
    }

    protected HttpResponseFactory newHttpResponseFactory() {
        return new DefaultHttpResponseFactory();
    }

    public int getAcceptedConnectionCount() {
        return this.acceptedConnections.get();
    }

    public void registerDefaultHandlers() {
        this.handlerRegistry.register("/echo/*", (HttpRequestHandler)new EchoHandler());
        this.handlerRegistry.register("/random/*", (HttpRequestHandler)new RandomHandler());
    }

    public void register(String pattern, HttpRequestHandler handler) {
        this.handlerRegistry.register(pattern, handler);
    }

    public void unregister(String pattern) {
        this.handlerRegistry.unregister(pattern);
    }

    public void start() throws Exception {
        ServerSocket ssock;
        if (this.servicedSocket != null) {
            throw new IllegalStateException(this.toString() + " already running");
        }
        if (this.sslcontext != null) {
            SSLServerSocketFactory sf = this.sslcontext.getServerSocketFactory();
            ssock = sf.createServerSocket();
        } else {
            ssock = new ServerSocket();
        }
        ssock.setReuseAddress(true);
        ssock.bind(TEST_SERVER_ADDR);
        this.servicedSocket = ssock;
        this.listenerThread = new ListenerThread();
        this.listenerThread.setDaemon(false);
        this.listenerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        if (this.servicedSocket == null) {
            return;
        }
        ListenerThread t = this.listenerThread;
        if (t != null) {
            t.shutdown();
        }
        Set<Worker> set = this.workers;
        synchronized (set) {
            for (Worker worker : this.workers) {
                worker.shutdown();
            }
        }
    }

    public void awaitTermination(long timeMs) throws InterruptedException {
        if (this.listenerThread != null) {
            this.listenerThread.join(timeMs);
        }
    }

    public String toString() {
        ServerSocket ssock = this.servicedSocket;
        StringBuilder sb = new StringBuilder(80);
        sb.append("LocalTestServer/");
        if (ssock == null) {
            sb.append("stopped");
        } else {
            sb.append(ssock.getLocalSocketAddress());
        }
        return sb.toString();
    }

    public InetSocketAddress getServiceAddress() {
        ServerSocket ssock = this.servicedSocket;
        if (ssock == null) {
            throw new IllegalStateException("not running");
        }
        return (InetSocketAddress)ssock.getLocalSocketAddress();
    }

    class Worker
    extends Thread {
        private final HttpServerConnection conn;
        private volatile Exception exception;

        public Worker(HttpServerConnection conn) {
            this.conn = conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BasicHttpContext context = new BasicHttpContext();
            try {
                while (this.conn.isOpen() && !Thread.interrupted()) {
                    LocalTestServer.this.httpservice.handleRequest(this.conn, (HttpContext)context);
                }
            }
            catch (Exception ex) {
                this.exception = ex;
            }
            finally {
                LocalTestServer.this.workers.remove(this);
                try {
                    this.conn.shutdown();
                }
                catch (IOException iOException) {}
            }
        }

        public void shutdown() {
            this.interrupt();
            try {
                this.conn.shutdown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public Exception getException() {
            return this.exception;
        }
    }

    class ListenerThread
    extends Thread {
        private volatile Exception exception;

        ListenerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!ListenerThread.interrupted()) {
                    Socket socket = LocalTestServer.this.servicedSocket.accept();
                    LocalTestServer.this.acceptedConnections.incrementAndGet();
                    DefaultHttpServerConnection conn = new DefaultHttpServerConnection();
                    conn.bind(socket, LocalTestServer.this.httpservice.getParams());
                    Worker worker = new Worker((HttpServerConnection)conn);
                    LocalTestServer.this.workers.add(worker);
                    worker.setDaemon(true);
                    worker.start();
                }
            }
            catch (Exception ex) {
                this.exception = ex;
            }
            finally {
                try {
                    LocalTestServer.this.servicedSocket.close();
                }
                catch (IOException iOException) {}
            }
        }

        public void shutdown() {
            this.interrupt();
            try {
                LocalTestServer.this.servicedSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

