/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.xml.actions;

import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class InsertBase64FileTextAreaAction
extends AbstractAction {
    private final RSyntaxTextArea textArea;
    private String dialogTitle;

    public InsertBase64FileTextAreaAction(RSyntaxTextArea editArea, String dialogTitle) {
        super("Insert file as Base64");
        this.textArea = editArea;
        this.dialogTitle = dialogTitle;
        if (UISupport.isMac()) {
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("meta G"));
        } else {
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("ctrl G"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file = UISupport.getFileDialogs().open(this, this.dialogTitle, null, null, null);
        if (file == null) {
            return;
        }
        try {
            byte[] ba = FileUtils.readFileToByteArray((File)file);
            Base64 b64 = new Base64();
            String hex = new String(b64.encode(ba));
            int pos = this.textArea.getCaretPosition();
            StringBuffer text = new StringBuffer(this.textArea.getText());
            text.insert(pos, hex);
            this.textArea.setText(text.toString());
        }
        catch (IOException e1) {
            UISupport.showErrorMessage("Error reading from file: " + e1.getMessage());
        }
    }
}

