/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.propertyexpansion;

import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.wsdl.MutableTestPropertyHolder;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditor;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.TestModelItem;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionImpl;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.support.JsonUtil;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.GroovyEditorComponent;
import com.eviware.soapui.support.components.ShowPopupAction;
import com.eviware.soapui.support.propertyexpansion.GroovyEditorPropertyExpansionTarget;
import com.eviware.soapui.support.propertyexpansion.JTextComponentPropertyExpansionTarget;
import com.eviware.soapui.support.propertyexpansion.PropertyExpansionDropTarget;
import com.eviware.soapui.support.propertyexpansion.PropertyExpansionTarget;
import com.eviware.soapui.support.propertyexpansion.RSyntaxTextAreaPropertyExpansionTarget;
import com.eviware.soapui.support.propertyexpansion.scrollmenu.ScrollableMenu;
import com.eviware.soapui.support.xml.XmlUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class PropertyExpansionPopupListener
implements PopupMenuListener {
    private final Container targetMenu;
    private final ModelItem modelItem;
    private final PropertyExpansionTarget target;
    private static final Pattern pattern = Pattern.compile("^\\$\\{(.*)\\}$");

    public PropertyExpansionPopupListener(Container transferMenu, ModelItem modelItem, PropertyExpansionTarget target) {
        this.modelItem = modelItem;
        this.target = target;
        this.targetMenu = transferMenu;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent arg0) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
        WsdlTestStep testStep;
        this.targetMenu.removeAll();
        WsdlTestCase testCase = null;
        WsdlTestSuite testSuite = null;
        WsdlProject project = null;
        MockService mockService = null;
        MockResponse mockResponse = null;
        SecurityTest securityTest = null;
        if (this.modelItem instanceof WsdlTestStep) {
            testStep = (WsdlTestStep)this.modelItem;
            testCase = testStep.getTestCase();
            testSuite = testCase.getTestSuite();
            project = testSuite.getProject();
        } else if (this.modelItem instanceof WsdlTestCase) {
            testCase = (WsdlTestCase)this.modelItem;
            testSuite = testCase.getTestSuite();
            project = testSuite.getProject();
        } else if (this.modelItem instanceof WsdlTestSuite) {
            testSuite = (WsdlTestSuite)this.modelItem;
            project = testSuite.getProject();
        } else if (this.modelItem instanceof WsdlMockService) {
            project = ((WsdlMockService)this.modelItem).getProject();
        } else if (this.modelItem instanceof MockResponse) {
            mockResponse = (MockResponse)this.modelItem;
            mockService = mockResponse.getMockOperation().getMockService();
            project = mockService.getProject();
        } else if (this.modelItem instanceof WsdlProject) {
            project = (WsdlProject)this.modelItem;
        } else if (this.modelItem instanceof AbstractHttpRequestInterface) {
            project = ((AbstractHttpRequest)this.modelItem).getOperation().getInterface().getProject();
        } else if (this.modelItem instanceof Operation) {
            project = (WsdlProject)((Operation)this.modelItem).getInterface().getProject();
        } else if (this.modelItem instanceof SecurityTest) {
            securityTest = (SecurityTest)this.modelItem;
            testCase = securityTest.getTestCase();
            testSuite = testCase.getTestSuite();
            project = testSuite.getProject();
        }
        MutableTestPropertyHolder globalProperties = PropertyExpansionUtils.getGlobalProperties();
        if (globalProperties.getProperties().size() > 0) {
            this.targetMenu.add(this.createPropertyMenu("Global", globalProperties));
        }
        if (project != null) {
            this.targetMenu.add(this.createPropertyMenu("Project: [" + project.getName() + "]", project));
        }
        if (testSuite != null) {
            this.targetMenu.add(this.createPropertyMenu("TestSuite: [" + testSuite.getName() + "]", testSuite));
        }
        if (mockService != null) {
            this.targetMenu.add(this.createPropertyMenu("MockService: [" + mockService.getName() + "]", mockService));
        }
        if (mockResponse != null) {
            this.targetMenu.add(this.createPropertyMenu("MockResponse: [" + mockResponse.getName() + "]", mockResponse));
        }
        if (testCase != null) {
            this.targetMenu.add(this.createPropertyMenu("TestCase: [" + testCase.getName() + "]", testCase));
            for (int c = 0; c < testCase.getTestStepCount(); ++c) {
                testStep = testCase.getTestStepAt(c);
                if (testStep.getPropertyNames().length == 0) continue;
                if (this.targetMenu.getComponentCount() == 3) {
                    this.targetMenu.add(new JSeparator());
                }
                this.targetMenu.add(this.createPropertyMenu("Step " + (c + 1) + ": [" + testStep.getName() + "]", testStep));
            }
        }
        if (securityTest != null) {
            this.targetMenu.add(this.createPropertyMenu("SecurityTest: [" + securityTest.getName() + "]", securityTest));
        }
    }

    private JMenu createPropertyMenu(String string, TestPropertyHolder holder) {
        String[] propertyNames;
        ScrollableMenu menu = new ScrollableMenu(string);
        if (holder instanceof TestModelItem) {
            menu.setIcon(((TestModelItem)holder).getIcon());
        }
        for (String name : propertyNames = holder.getPropertyNames()) {
            menu.add(new TransferFromPropertyActionInvoker(holder, name));
        }
        if (holder instanceof MutableTestPropertyHolder) {
            menu.addHeader(new TransferFromPropertyActionInvoker((MutableTestPropertyHolder)holder));
        }
        return menu;
    }

    private static boolean userInputIsPropertyExpansion(String userSelectedValue) {
        if (userSelectedValue == null) {
            return false;
        }
        Matcher matcher = pattern.matcher(userSelectedValue);
        return matcher.matches();
    }

    public static void addMenu(JPopupMenu popup, String menuName, ModelItem item, PropertyExpansionTarget component) {
        ScrollableMenu menu = new ScrollableMenu(menuName);
        menu.setName(menuName);
        boolean contains = false;
        for (int i = 0; i < popup.getComponentCount(); ++i) {
            if (menu.getName() == null || !menu.getName().equals(popup.getComponent(i).getName())) continue;
            contains = true;
            break;
        }
        if (!contains) {
            popup.add(menu);
            popup.addPopupMenuListener(new PropertyExpansionPopupListener(menu, item, component));
        }
    }

    public static void enable(JTextComponent textField, ModelItem modelItem, JPopupMenu popup) {
        JTextComponentPropertyExpansionTarget target = new JTextComponentPropertyExpansionTarget(textField, modelItem);
        DropTarget dropTarget = new DropTarget(textField, new PropertyExpansionDropTarget(target));
        dropTarget.setDefaultActions(3);
        textField.setComponentPopupMenu(popup);
        if (popup != null) {
            PropertyExpansionPopupListener.addMenu(popup, "Get Data...", target.getContextModelItem(), target);
        }
    }

    public static JPanel addPropertyExpansionPopup(JTextField textField, JPopupMenu popup, ModelItem modelItem) {
        PropertyExpansionPopupListener.enable(textField, modelItem, popup);
        JButton popupButton = new JButton();
        popupButton.setAction(new ShowPopupAction(textField, popupButton));
        popupButton.setBackground(Color.WHITE);
        popupButton.setForeground(Color.WHITE);
        popupButton.setBorder(null);
        popupButton.setOpaque(true);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)textField, "Center");
        panel.add((Component)popupButton, "East");
        panel.setBorder(textField.getBorder());
        textField.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return panel;
    }

    public static void enable(RSyntaxTextArea textField, ModelItem modelItem) {
        RSyntaxTextAreaPropertyExpansionTarget target = new RSyntaxTextAreaPropertyExpansionTarget(textField, modelItem);
        DropTarget dropTarget = new DropTarget((Component)textField, new PropertyExpansionDropTarget(target));
        dropTarget.setDefaultActions(3);
        JPopupMenu popup = textField.getPopupMenu();
        if (popup != null) {
            PropertyExpansionPopupListener.addMenu(popup, "Get Data...", target.getContextModelItem(), target);
        }
    }

    public static void enable(GroovyEditor groovyEditor, ModelItem modelItem) {
        GroovyEditorPropertyExpansionTarget target = new GroovyEditorPropertyExpansionTarget(groovyEditor, modelItem);
        DropTarget dropTarget = new DropTarget((Component)groovyEditor.getEditArea(), new PropertyExpansionDropTarget(target));
        dropTarget.setDefaultActions(3);
        JPopupMenu popup = groovyEditor.getEditArea().getComponentPopupMenu();
        if (popup != null) {
            ScrollableMenu menu = new ScrollableMenu("Get Data...");
            popup.insert(menu, 0);
            popup.addPopupMenuListener(new PropertyExpansionPopupListener(menu, target.getContextModelItem(), target));
            popup.insert(new JSeparator(), 1);
        }
    }

    public static void enable(JTextComponent textField, ModelItem modelItem) {
        JPopupMenu popupMenu = textField.getComponentPopupMenu();
        if (popupMenu == null) {
            popupMenu = new JPopupMenu();
            textField.setComponentPopupMenu(popupMenu);
        }
        PropertyExpansionPopupListener.enable(textField, modelItem, popupMenu);
    }

    public static void enable(GroovyEditorComponent gec, ModelItem modelItem) {
        PropertyExpansionPopupListener.enable(gec.getEditor(), modelItem);
    }

    private class TransferFromPropertyActionInvoker
    extends AbstractAction {
        private final TestPropertyHolder sourceStep;
        private String sourceProperty;

        public TransferFromPropertyActionInvoker(TestPropertyHolder sourceStep, String sourceProperty) {
            super("Property [" + sourceProperty + "]");
            this.sourceStep = sourceStep;
            this.sourceProperty = sourceProperty;
        }

        public TransferFromPropertyActionInvoker(MutableTestPropertyHolder testStep) {
            super("Create new...");
            this.sourceStep = testStep;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (this.sourceProperty == null && this.sourceStep instanceof MutableTestPropertyHolder) {
                MutableTestPropertyHolder step = (MutableTestPropertyHolder)this.sourceStep;
                this.sourceProperty = PropertyExpansionPopupListener.this.target.getNameForCreation();
                this.sourceProperty = UISupport.prompt("Specify name of source property to create", "Create source property", this.sourceProperty);
                while (this.sourceProperty != null && step.getProperty(this.sourceProperty) != null) {
                    this.sourceProperty = UISupport.prompt("Name is taken, specify unique name of source property to create", "Create source property", this.sourceProperty);
                }
                if (this.sourceProperty == null) {
                    return;
                }
                ((MutableTestPropertyHolder)this.sourceStep).addProperty(this.sourceProperty);
                String newVal = UISupport.prompt("Specify the value of the new property '" + this.sourceProperty + "'", "Set the value of the property", "");
                if (newVal != null) {
                    this.sourceStep.setPropertyValue(this.sourceProperty, newVal);
                }
            }
            String sourceXPath = "";
            String val = this.sourceStep.getPropertyValue(this.sourceProperty);
            try {
                String defaultValue;
                if (StringUtils.isNullOrEmpty(val) && StringUtils.hasContent(defaultValue = this.sourceStep.getProperty(this.sourceProperty).getDefaultValue()) && UISupport.confirm("Missing property value, use default value instead?", "Get Data")) {
                    val = defaultValue;
                }
                if (XmlUtils.seemsToBeXml(val)) {
                    XmlUtils.createXmlObject(val);
                    sourceXPath = UISupport.selectXPath("Select XPath", "Select source xpath", val, null);
                } else if (JsonUtil.isValidJson(val)) {
                    sourceXPath = UISupport.selectJsonPath("Select JSON", "Select JSON value", val, null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (StringUtils.hasContent(sourceXPath)) {
                sourceXPath = PropertyExpansionUtils.shortenXPathForPropertyExpansion(sourceXPath, val);
            }
            TestProperty property = this.sourceStep.getProperty(this.sourceProperty);
            PropertyExpansionImpl pe = new PropertyExpansionImpl(property, sourceXPath);
            String userSelectedValue = PropertyExpansionPopupListener.this.target.getValueForCreation();
            PropertyExpansionPopupListener.this.target.insertPropertyExpansion(pe, null);
            if (!StringUtils.hasContent(sourceXPath) && StringUtils.hasContent(userSelectedValue) && !property.isReadOnly() && !PropertyExpansionPopupListener.userInputIsPropertyExpansion(userSelectedValue) && (userSelectedValue = UISupport.prompt("Do you want to update the value of the property? (" + val + ")", "Get Data", userSelectedValue)) != null) {
                property.setValue(userSelectedValue);
            }
        }
    }
}

