/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.jms.property;

import com.eviware.soapui.impl.wsdl.panels.request.StringToStringMapTableModel;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.editor.EditorView;
import com.eviware.soapui.support.editor.inspectors.AbstractXmlInspector;
import com.eviware.soapui.support.editor.inspectors.jms.property.JMSPropertyInspectorModel;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.eviware.soapui.support.swing.JTableFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class JMSPropertyInspector
extends AbstractXmlInspector
implements PropertyChangeListener {
    private StringToStringMapTableModel headersTableModel;
    private final JMSPropertyInspectorModel model;
    private JTable headersTable;
    private JPanel panel;
    private JButton removeButton;
    public boolean changing;

    protected JMSPropertyInspector(JMSPropertyInspectorModel model) {
        super("JMS Properties (" + (model.getJMSProperties() == null ? "0" : Integer.valueOf(model.getJMSProperties().size())) + ")", "Additional JMS Property for this message", true, "JMS Properties");
        this.model = model;
        model.addPropertyChangeListener(this);
        model.setInspector(this);
    }

    @Override
    public JComponent getComponent() {
        if (this.panel != null) {
            return this.panel;
        }
        this.headersTableModel = new StringToStringMapTableModel(this.model.getJMSProperties(), "Key", "Value", !this.model.isReadOnly());
        this.headersTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                JMSPropertyInspector.this.model.setJMSProperties(JMSPropertyInspector.this.headersTableModel.getData());
                JMSPropertyInspector.this.setTitle("JMS Property (" + (JMSPropertyInspector.this.model.getJMSProperties() == null ? "0" : Integer.valueOf(JMSPropertyInspector.this.model.getJMSProperties().size())) + ")");
            }
        });
        this.headersTable = JTableFactory.getInstance().makeJTable(this.headersTableModel);
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)new JScrollPane(this.headersTable), "Center");
        if (!this.model.isReadOnly()) {
            this.headersTable.setSurrendersFocusOnKeystroke(true);
            this.headersTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
            JXToolBar builder = UISupport.createSmallToolbar();
            builder.addFixed(UISupport.createToolbarButton(new AddAction()));
            this.removeButton = UISupport.createToolbarButton(new RemoveAction());
            builder.addFixed(this.removeButton);
            builder.addGlue();
            this.panel.add((Component)builder, "North");
            this.headersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    JMSPropertyInspector.this.removeButton.setEnabled(JMSPropertyInspector.this.headersTable.getSelectedRow() != -1);
                }
            });
            if (this.headersTable.getRowCount() > 0) {
                this.headersTable.setRowSelectionInterval(0, 0);
            } else {
                this.removeButton.setEnabled(false);
            }
        }
        return this.panel;
    }

    public JTable getHeadersTable() {
        return this.headersTable;
    }

    @Override
    public void release() {
        super.release();
        this.model.release();
        this.model.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.changing) {
            this.headersTableModel.setData(this.model.getJMSProperties());
        }
    }

    @Override
    public boolean isEnabledFor(EditorView<XmlDocument> view) {
        return !view.getViewId().equals("Raw");
    }

    private final class AddAction
    extends AbstractAction {
        private AddAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add.png"));
            this.putValue("ShortDescription", "Adds a custom JMS Property to this message");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            String header = UISupport.prompt("Specify name of JMS Property to add", "Add JMS Property", "");
            if (header != null) {
                JMSPropertyInspector.this.changing = true;
                JMSPropertyInspector.this.headersTableModel.add(header.toString(), "");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int row = JMSPropertyInspector.this.headersTable.getRowCount() - 1;
                        JMSPropertyInspector.this.headersTable.scrollRectToVisible(JMSPropertyInspector.this.headersTable.getCellRect(row, 1, true));
                        JMSPropertyInspector.this.headersTable.setRowSelectionInterval(row, row);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JMSPropertyInspector.this.headersTable.editCellAt(JMSPropertyInspector.this.headersTable.getRowCount() - 1, 1);
                                JMSPropertyInspector.this.headersTable.getEditorComponent().requestFocusInWindow();
                            }
                        });
                    }
                });
                JMSPropertyInspector.this.changing = false;
            }
        }
    }

    private final class RemoveAction
    extends AbstractAction {
        private RemoveAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/delete.png"));
            this.putValue("ShortDescription", "Removes the selected custom JMS Property from this message");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int row = JMSPropertyInspector.this.headersTable.getSelectedRow();
            if (row != -1 && UISupport.confirm("Delete selected JMS Property?", "Remove JMS Property")) {
                JMSPropertyInspector.this.changing = true;
                JMSPropertyInspector.this.headersTableModel.remove(row);
                JMSPropertyInspector.this.changing = false;
            }
        }
    }
}

