/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.support.TestPropertyListenerAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class TestStepPropertyComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    private WsdlTestStep testStep;
    private List<String> names;
    private String selectedName;
    private InternalTestPropertyListener testStepListener = new InternalTestPropertyListener();

    public TestStepPropertyComboBoxModel(WsdlTestStep testStep) {
        this.testStep = testStep;
        this.names = new ArrayList<String>();
        if (testStep != null) {
            this.names.addAll(Arrays.asList(testStep.getPropertyNames()));
            testStep.addTestPropertyListener(this.testStepListener);
        }
    }

    public void release() {
        if (this.testStep != null) {
            this.testStep.removeTestPropertyListener(this.testStepListener);
        }
    }

    public WsdlTestStep getTestStep() {
        return this.testStep;
    }

    public void setTestStep(WsdlTestStep testStep) {
        int sz;
        if (this.testStep != null) {
            this.testStep.removeTestPropertyListener(this.testStepListener);
        }
        if ((sz = this.names.size()) > 0) {
            this.names.clear();
            this.fireIntervalRemoved(this, 0, sz - 1);
        }
        this.testStep = testStep;
        if (testStep != null) {
            testStep.addTestPropertyListener(this.testStepListener);
            this.names.addAll(Arrays.asList(testStep.getPropertyNames()));
            if (!this.names.isEmpty()) {
                this.fireIntervalAdded(this, 0, this.names.size() - 1);
            }
        }
        this.setSelectedItem(null);
    }

    @Override
    public Object getElementAt(int index) {
        return this.names.get(index);
    }

    @Override
    public int getSize() {
        return this.names.size();
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedName;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (anItem == null && this.selectedName == null) {
            return;
        }
        if (anItem != null && this.selectedName != null && anItem.equals(this.selectedName)) {
            return;
        }
        this.selectedName = anItem == null ? null : anItem.toString();
        this.fireContentsChanged(this, -1, -1);
    }

    private final class InternalTestPropertyListener
    extends TestPropertyListenerAdapter {
        private InternalTestPropertyListener() {
        }

        @Override
        public void propertyAdded(String name) {
            TestStepPropertyComboBoxModel.this.names.add(name);
            TestStepPropertyComboBoxModel.this.fireIntervalAdded(TestStepPropertyComboBoxModel.this, TestStepPropertyComboBoxModel.this.names.size() - 1, TestStepPropertyComboBoxModel.this.names.size() - 1);
        }

        @Override
        public void propertyRemoved(String name) {
            int ix = TestStepPropertyComboBoxModel.this.names.indexOf(name);
            if (ix >= 0) {
                TestStepPropertyComboBoxModel.this.names.remove(ix);
                TestStepPropertyComboBoxModel.this.fireIntervalRemoved(TestStepPropertyComboBoxModel.this, ix, ix);
                if (name.equals(TestStepPropertyComboBoxModel.this.selectedName)) {
                    TestStepPropertyComboBoxModel.this.setSelectedItem(null);
                }
            }
        }

        @Override
        public void propertyRenamed(String oldName, String newName) {
            int ix = TestStepPropertyComboBoxModel.this.names.indexOf(oldName);
            TestStepPropertyComboBoxModel.this.fireContentsChanged(TestStepPropertyComboBoxModel.this, ix, ix);
            if (oldName.equals(TestStepPropertyComboBoxModel.this.selectedName)) {
                TestStepPropertyComboBoxModel.this.setSelectedItem(newName);
            }
        }

        @Override
        public void propertyMoved(String name, int oldIndex, int newIndex) {
            TestStepPropertyComboBoxModel.this.fireContentsChanged(TestStepPropertyComboBoxModel.this, 0, TestStepPropertyComboBoxModel.this.getSize() - 1);
        }
    }
}

