/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.actions;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.actions.FindAndReplaceable;
import com.eviware.soapui.support.xml.ProxyFindAndReplacable;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public class FindAndReplaceDialog
extends AbstractAction {
    private final ProxyFindAndReplacable target;
    private JDialog dialog;
    private JCheckBox caseCheck;
    private JRadioButton allButton;
    private JRadioButton selectedLinesButton;
    private JRadioButton forwardButton;
    private JRadioButton backwardButton;
    private JCheckBox wholeWordCheck;
    private JButton findButton;
    private JButton replaceButton;
    private JButton replaceAllButton;
    private JComboBox findCombo;
    private JComboBox replaceCombo;
    private JCheckBox wrapCheck;

    public FindAndReplaceDialog(FindAndReplaceable target) {
        super("Find / Replace");
        if (UISupport.isMac()) {
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("meta F"));
        } else {
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("control F"));
        }
        this.target = new ProxyFindAndReplacable(target);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.show();
    }

    public void show() {
        if (this.dialog == null) {
            this.buildDialog();
        }
        this.target.getEditComponent().requestFocusInWindow();
        this.replaceCombo.setEnabled(this.target.isEditable());
        this.replaceAllButton.setEnabled(this.target.isEditable());
        this.replaceButton.setEnabled(this.target.isEditable());
        UISupport.showDialog(this.dialog);
        this.findCombo.getEditor().selectAll();
        this.findCombo.requestFocus();
    }

    private void buildDialog() {
        Window window = SwingUtilities.windowForComponent(this.target.getEditComponent());
        this.dialog = new JDialog(window, "Find / Replace");
        this.dialog.setModal(false);
        JPanel panel = new JPanel(new BorderLayout());
        this.findCombo = new JComboBox();
        this.findCombo.setEditable(true);
        this.replaceCombo = new JComboBox();
        this.replaceCombo.setEditable(true);
        GridLayout gridLayout = new GridLayout(2, 2);
        gridLayout.setVgap(5);
        JPanel inputPanel = new JPanel(gridLayout);
        inputPanel.add(new JLabel("Find:"));
        inputPanel.add(this.findCombo);
        inputPanel.add(new JLabel("Replace with:"));
        inputPanel.add(this.replaceCombo);
        inputPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        ButtonGroup directionGroup = new ButtonGroup();
        this.forwardButton = new JRadioButton("Forward", true);
        this.forwardButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        directionGroup.add(this.forwardButton);
        this.backwardButton = new JRadioButton("Backward");
        this.backwardButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        directionGroup.add(this.backwardButton);
        JPanel directionPanel = new JPanel(new GridLayout(2, 1));
        directionPanel.add(this.forwardButton);
        directionPanel.add(this.backwardButton);
        directionPanel.setBorder(BorderFactory.createTitledBorder("Direction"));
        ButtonGroup scopeGroup = new ButtonGroup();
        this.allButton = new JRadioButton("All", true);
        this.allButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.selectedLinesButton = new JRadioButton("Selected Lines");
        this.selectedLinesButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        scopeGroup.add(this.allButton);
        scopeGroup.add(this.selectedLinesButton);
        JPanel scopePanel = new JPanel(new GridLayout(2, 1));
        scopePanel.add(this.allButton);
        scopePanel.add(this.selectedLinesButton);
        scopePanel.setBorder(BorderFactory.createTitledBorder("Scope"));
        this.caseCheck = new JCheckBox("Case Sensitive");
        this.caseCheck.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.wholeWordCheck = new JCheckBox("Whole Word");
        this.wholeWordCheck.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.wrapCheck = new JCheckBox("Wrap Search");
        this.wrapCheck.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JPanel optionsPanel = new JPanel(new GridLayout(3, 1));
        optionsPanel.add(this.caseCheck);
        optionsPanel.add(this.wholeWordCheck);
        optionsPanel.add(this.wrapCheck);
        optionsPanel.setBorder(BorderFactory.createTitledBorder("Options"));
        JPanel options = new JPanel(new GridLayout(1, 2));
        JPanel radios = new JPanel(new GridLayout(2, 1));
        radios.add(directionPanel);
        radios.add(scopePanel);
        options.add(optionsPanel);
        options.add(radios);
        options.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        ButtonBarBuilder builder = new ButtonBarBuilder();
        this.findButton = new JButton(new FindAction());
        builder.addFixed((JComponent)this.findButton);
        builder.addRelatedGap();
        this.replaceButton = new JButton(new ReplaceAction());
        builder.addFixed((JComponent)this.replaceButton);
        builder.addRelatedGap();
        this.replaceAllButton = new JButton(new ReplaceAllAction());
        builder.addFixed((JComponent)this.replaceAllButton);
        builder.addUnrelatedGap();
        builder.addFixed((JComponent)new JButton(new CloseAction()));
        builder.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        panel.add((Component)inputPanel, "North");
        panel.add((Component)options, "Center");
        panel.add((Component)builder.getPanel(), "South");
        this.dialog.getContentPane().add(panel);
        this.dialog.pack();
        UISupport.initDialogActions(this.dialog, null, this.findButton);
    }

    private int findNext(int pos, String txt, String value) {
        int ix;
        int n = ix = this.forwardButton.isSelected() ? txt.indexOf(value, pos) : txt.lastIndexOf(value, pos);
        if (this.selectedLinesButton.isSelected() && (ix < this.target.getSelectionStart() || ix > this.target.getSelectionEnd())) {
            ix = -1;
        }
        if (this.wholeWordCheck.isSelected()) {
            while (ix != -1 && (ix > 0 && Character.isLetterOrDigit(txt.charAt(ix - 1)) || ix < txt.length() - value.length() - 1 && Character.isLetterOrDigit(txt.charAt(ix + value.length())))) {
                ix = this.forwardButton.isSelected() ? ++ix : --ix;
                ix = this.forwardButton.isSelected() ? txt.indexOf(value, ix) : txt.lastIndexOf(value, ix);
            }
        }
        if (ix == -1 && this.wrapCheck.isSelected()) {
            if (this.forwardButton.isSelected() && pos > 0) {
                return this.findNext(0, txt, value);
            }
            if (this.backwardButton.isSelected() && pos < txt.length() - 1) {
                return this.findNext(txt.length() - 1, txt, value);
            }
        }
        return ix;
    }

    private int tweakPosition() {
        int pos = this.target.getCaretPosition();
        if (this.selectedLinesButton.isSelected()) {
            if (this.forwardButton.isSelected()) {
                int selstart = this.target.getSelectionStart();
                if (selstart < pos && selstart != -1) {
                    pos = selstart;
                }
            } else {
                int selend = this.target.getSelectionEnd();
                if (selend > pos && selend != -1) {
                    pos = selend;
                }
            }
        } else {
            int selstart = this.target.getSelectionStart();
            if (selstart < pos && selstart != -1) {
                pos = selstart;
            }
        }
        return pos;
    }

    private int tweakLastPosition() {
        return this.forwardButton.isSelected() ? this.target.getSelectionEnd() : this.target.getSelectionStart();
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super("Close");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FindAndReplaceDialog.this.dialog.setVisible(false);
        }
    }

    private class ReplaceAllAction
    extends AbstractAction {
        public ReplaceAllAction() {
            super("Replace All");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String newValue;
            int pos = FindAndReplaceDialog.this.tweakPosition();
            String txt = FindAndReplaceDialog.this.target.getDialogText();
            if (FindAndReplaceDialog.this.findCombo.getSelectedItem() == null) {
                return;
            }
            String value = FindAndReplaceDialog.this.findCombo.getSelectedItem().toString();
            if (value.length() == 0 || txt.length() == 0) {
                return;
            }
            String string = newValue = FindAndReplaceDialog.this.replaceCombo.getSelectedItem() == null ? "" : FindAndReplaceDialog.this.replaceCombo.getSelectedItem().toString();
            if (!FindAndReplaceDialog.this.caseCheck.isSelected()) {
                if (newValue.equalsIgnoreCase(value)) {
                    return;
                }
                value = value.toLowerCase();
                txt = txt.toLowerCase();
            } else if (newValue.equals(value)) {
                return;
            }
            int ix = FindAndReplaceDialog.this.findNext(pos, txt, value);
            if (ix >= 0) {
                int firstIx = ix;
                int valueInNewValueIx = !FindAndReplaceDialog.this.caseCheck.isSelected() ? newValue.toLowerCase().indexOf(value) : newValue.indexOf(value);
                FindAndReplaceDialog.this.target.setReplaceAll(true);
                FindAndReplaceDialog.this.target.setSBTarget();
                FindAndReplaceDialog.this.target.setNewValue(newValue);
                while (ix != -1) {
                    FindAndReplaceDialog.this.target.select(ix, ix + value.length());
                    FindAndReplaceDialog.this.target.setSelectedText(newValue);
                    FindAndReplaceDialog.this.target.select(ix, ix + newValue.length());
                    if (ix < firstIx) {
                        firstIx += newValue.length() - value.length();
                    }
                    txt = FindAndReplaceDialog.this.target.getText();
                    if (!FindAndReplaceDialog.this.caseCheck.isSelected()) {
                        txt = txt.toLowerCase();
                    }
                    ix = FindAndReplaceDialog.this.forwardButton.isSelected() ? FindAndReplaceDialog.this.findNext(ix + newValue.length(), txt, value) : FindAndReplaceDialog.this.findNext(ix - 1, txt, value);
                    if (!FindAndReplaceDialog.this.wrapCheck.isSelected() || valueInNewValueIx == -1 || ix != firstIx + valueInNewValueIx) continue;
                }
                FindAndReplaceDialog.this.target.flushSBText();
                FindAndReplaceDialog.this.target.setReplaceAll(false);
                FindAndReplaceDialog.this.target.setCarretPosition(FindAndReplaceDialog.this.forwardButton.isSelected());
            } else {
                UISupport.showErrorMessage("String [" + value + "] not found");
            }
        }
    }

    private class ReplaceAction
    extends AbstractAction {
        String lastSearchedItem;
        int lastPositionF;

        public ReplaceAction() {
            super("Replace/Replace Next");
            this.lastSearchedItem = "";
            this.lastPositionF = -1;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String newValue;
            int pos = FindAndReplaceDialog.this.tweakPosition();
            int lastpos = FindAndReplaceDialog.this.tweakLastPosition();
            String txt = FindAndReplaceDialog.this.target.getText();
            if (FindAndReplaceDialog.this.findCombo.getSelectedItem() == null) {
                return;
            }
            String value = FindAndReplaceDialog.this.findCombo.getSelectedItem().toString();
            if (value.length() == 0 || txt.length() == 0) {
                return;
            }
            String string = newValue = FindAndReplaceDialog.this.replaceCombo.getSelectedItem() == null ? "" : FindAndReplaceDialog.this.replaceCombo.getSelectedItem().toString();
            if (!FindAndReplaceDialog.this.caseCheck.isSelected()) {
                if (newValue.equalsIgnoreCase(value)) {
                    return;
                }
                value = value.toLowerCase();
                txt = txt.toLowerCase();
            } else if (newValue.equals(value)) {
                return;
            }
            if (pos == this.lastPositionF && value.equals(this.lastSearchedItem)) {
                pos = FindAndReplaceDialog.this.forwardButton.isSelected() ? (pos += value.length() + 1) : (pos -= value.length() - 1);
            }
            int ix = FindAndReplaceDialog.this.findNext(pos, txt, value);
            this.lastSearchedItem = value;
            this.lastPositionF = ix;
            int firstIx = ix;
            if (ix != -1) {
                FindAndReplaceDialog.this.target.select(ix, ix + value.length());
                FindAndReplaceDialog.this.target.setSelectedText(newValue);
                if (FindAndReplaceDialog.this.selectedLinesButton.isSelected()) {
                    FindAndReplaceDialog.this.target.select(ix, lastpos);
                } else {
                    FindAndReplaceDialog.this.target.select(ix, ix + newValue.length());
                }
                if (ix < firstIx) {
                    firstIx += newValue.length() - value.length();
                }
                txt = FindAndReplaceDialog.this.target.getText();
                if (!FindAndReplaceDialog.this.caseCheck.isSelected()) {
                    txt = txt.toLowerCase();
                }
                ix = FindAndReplaceDialog.this.forwardButton.isSelected() ? FindAndReplaceDialog.this.findNext(ix + newValue.length(), txt, value) : FindAndReplaceDialog.this.findNext(ix - 1, txt, value);
            } else {
                UISupport.showErrorMessage("String [" + value + "] not found");
            }
        }
    }

    private class FindAction
    extends AbstractAction {
        String lastSearchedItem;
        int lastPositionF;

        public FindAction() {
            super("Find/Find Next");
            this.lastSearchedItem = "";
            this.lastPositionF = -1;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int pos = FindAndReplaceDialog.this.tweakPosition();
            int lastpos = FindAndReplaceDialog.this.tweakLastPosition();
            String txt = FindAndReplaceDialog.this.target.getText();
            if (FindAndReplaceDialog.this.findCombo.getSelectedItem() == null) {
                return;
            }
            String value = FindAndReplaceDialog.this.findCombo.getSelectedItem().toString();
            if (value.length() == 0 || pos == txt.length() && !FindAndReplaceDialog.this.wrapCheck.isSelected()) {
                return;
            }
            if (!FindAndReplaceDialog.this.caseCheck.isSelected()) {
                value = value.toLowerCase();
                txt = txt.toLowerCase();
            }
            if (pos == this.lastPositionF && value.equals(this.lastSearchedItem)) {
                pos = FindAndReplaceDialog.this.forwardButton.isSelected() ? (pos += value.length() + 1) : (pos -= value.length() - 1);
            }
            int ix = FindAndReplaceDialog.this.findNext(pos, txt, value);
            this.lastSearchedItem = value;
            this.lastPositionF = ix;
            if (ix != -1) {
                if (FindAndReplaceDialog.this.selectedLinesButton.isSelected()) {
                    FindAndReplaceDialog.this.target.select(ix, lastpos);
                } else {
                    FindAndReplaceDialog.this.target.select(ix, ix + value.length());
                }
                for (int c = 0; c < FindAndReplaceDialog.this.findCombo.getItemCount(); ++c) {
                    if (!FindAndReplaceDialog.this.findCombo.getItemAt(c).equals(value)) continue;
                    FindAndReplaceDialog.this.findCombo.removeItem(c);
                    break;
                }
                FindAndReplaceDialog.this.findCombo.insertItemAt(value, 0);
            } else {
                UISupport.showErrorMessage("String [" + value + "] not found");
            }
        }
    }
}

