/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.result;

import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.security.result.SecurityResult;
import com.eviware.soapui.security.result.SecurityScanRequestResult;
import com.eviware.soapui.security.result.SecurityScanResult;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;

public class SecurityTestStepResult
implements SecurityResult {
    private SecurityResult.ResultStatus status = SecurityResult.ResultStatus.UNKNOWN;
    public static final String TYPE = "SecurityTestStepResult";
    private TestStep testStep;
    private long size;
    private List<SecurityScanResult> securityScanResultList;
    private boolean discarded;
    private long timeTaken = 0L;
    private long timeStamp;
    private StringBuffer testLog = new StringBuffer();
    private TestStepResult originalTestStepResult;
    private DefaultActionList actionList;
    private boolean hasAddedRequests;
    private SecurityResult.ResultStatus executionProgressStatus = SecurityResult.ResultStatus.UNKNOWN;
    private SecurityResult.ResultStatus logIconStatus = SecurityResult.ResultStatus.UNKNOWN;
    private boolean hasScansWithWarnings;

    public SecurityTestStepResult(TestStep testStep, TestStepResult originalResult) {
        this.testStep = testStep;
        this.executionProgressStatus = SecurityResult.ResultStatus.INITIALIZED;
        this.securityScanResultList = new ArrayList<SecurityScanResult>();
        this.timeStamp = System.currentTimeMillis();
        this.originalTestStepResult = originalResult;
    }

    public List<SecurityScanResult> getSecurityScanResultList() {
        return this.securityScanResultList;
    }

    @Override
    public SecurityResult.ResultStatus getStatus() {
        return this.status;
    }

    public void setStatus(SecurityResult.ResultStatus status) {
        this.status = status;
    }

    @Override
    public ActionList getActions() {
        if (this.actionList == null) {
            this.actionList = new DefaultActionList(this.getTestStep().getName());
            this.actionList.setDefaultAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UISupport.showInfoMessage("Step [" + SecurityTestStepResult.this.getTestStep().getName() + "] ran with security status [" + (Object)((Object)SecurityTestStepResult.this.getExecutionProgressStatus()) + "]", "TestStep Result");
                }
            });
        }
        return this.actionList;
    }

    public void addSecurityScanResult(SecurityScanResult securityScanResult) {
        if (this.securityScanResultList != null) {
            this.securityScanResultList.add(securityScanResult);
        }
        this.timeTaken += securityScanResult.getTimeTaken();
        if (!this.hasAddedRequests) {
            this.status = securityScanResult.getStatus();
        } else if (this.status != SecurityResult.ResultStatus.FAILED) {
            this.status = securityScanResult.getStatus();
        }
        securityScanResult.detectMissingItems();
        if (!this.hasAddedRequests) {
            this.executionProgressStatus = securityScanResult.getExecutionProgressStatus();
        } else if (securityScanResult.getExecutionProgressStatus().equals((Object)SecurityResult.ResultStatus.CANCELED)) {
            this.executionProgressStatus = securityScanResult.getExecutionProgressStatus();
        } else if (securityScanResult.getExecutionProgressStatus().equals((Object)SecurityResult.ResultStatus.MISSING_PARAMETERS) && this.executionProgressStatus != SecurityResult.ResultStatus.CANCELED) {
            this.executionProgressStatus = SecurityResult.ResultStatus.MISSING_PARAMETERS;
        } else if (securityScanResult.getExecutionProgressStatus().equals((Object)SecurityResult.ResultStatus.MISSING_ASSERTIONS) && this.executionProgressStatus != SecurityResult.ResultStatus.CANCELED && this.executionProgressStatus != SecurityResult.ResultStatus.MISSING_PARAMETERS) {
            this.executionProgressStatus = SecurityResult.ResultStatus.MISSING_ASSERTIONS;
        } else if (securityScanResult.getExecutionProgressStatus().equals((Object)SecurityResult.ResultStatus.FAILED) && this.executionProgressStatus != SecurityResult.ResultStatus.CANCELED && this.executionProgressStatus != SecurityResult.ResultStatus.MISSING_PARAMETERS && this.executionProgressStatus != SecurityResult.ResultStatus.MISSING_ASSERTIONS) {
            this.executionProgressStatus = SecurityResult.ResultStatus.FAILED;
        } else if (securityScanResult.getExecutionProgressStatus().equals((Object)SecurityResult.ResultStatus.OK) && this.executionProgressStatus != SecurityResult.ResultStatus.CANCELED && this.executionProgressStatus != SecurityResult.ResultStatus.MISSING_PARAMETERS && this.executionProgressStatus != SecurityResult.ResultStatus.MISSING_ASSERTIONS && this.executionProgressStatus != SecurityResult.ResultStatus.FAILED) {
            this.executionProgressStatus = SecurityResult.ResultStatus.OK;
        }
        if (securityScanResult.getLogIconStatus().equals((Object)SecurityResult.ResultStatus.FAILED)) {
            this.logIconStatus = securityScanResult.getLogIconStatus();
        } else if ((securityScanResult.getLogIconStatus().equals((Object)SecurityResult.ResultStatus.MISSING_ASSERTIONS) || securityScanResult.getLogIconStatus().equals((Object)SecurityResult.ResultStatus.MISSING_PARAMETERS)) && this.logIconStatus != SecurityResult.ResultStatus.FAILED) {
            this.logIconStatus = securityScanResult.getLogIconStatus();
        } else if (securityScanResult.getLogIconStatus().equals((Object)SecurityResult.ResultStatus.OK) && this.logIconStatus != SecurityResult.ResultStatus.FAILED && this.logIconStatus != SecurityResult.ResultStatus.MISSING_ASSERTIONS && this.logIconStatus != SecurityResult.ResultStatus.MISSING_PARAMETERS) {
            this.logIconStatus = SecurityResult.ResultStatus.OK;
        }
        this.testLog.append(securityScanResult.getSecurityTestLog());
        this.hasAddedRequests = true;
        if (securityScanResult.isHasRequestsWithWarnings()) {
            this.hasScansWithWarnings = true;
        }
    }

    public boolean isHasScansWithWarnings() {
        return this.hasScansWithWarnings;
    }

    public long getTimeTaken() {
        return this.timeTaken;
    }

    public long getSize() {
        return this.size;
    }

    public void writeTo(PrintWriter writer) {
        for (SecurityScanResult scanResult : this.securityScanResultList) {
            int i = 0;
            for (SecurityScanRequestResult scanRequestResult : scanResult.getSecurityRequestResultList()) {
                writer.println();
                writer.println("----------------------------------------------------------------------------------");
                writer.println(scanRequestResult.getChangedParamsInfo(i));
                for (String message : scanRequestResult.getMessages()) {
                    writer.println("->" + message);
                }
                writer.println();
                writer.println("Properties -----------------------------------------------------------------------");
                writer.println();
                for (String name : scanRequestResult.getMessageExchange().getProperties().keySet()) {
                    if (scanRequestResult.getMessageExchange().getProperties().get(name) == null) continue;
                    writer.println(name + " = " + (String)scanRequestResult.getMessageExchange().getProperties().get(name));
                }
                writer.println();
                writer.println("Request ---------------------------------------------------------------------------");
                writer.println();
                writer.println(new String(scanRequestResult.getMessageExchange().getRawRequestData()));
                writer.println();
                writer.println("Response --------------------------------------------------------------------------");
                writer.println();
                writer.println(new String(scanRequestResult.getMessageExchange().getRawResponseData()));
                writer.println("-----------------------------------------------------------------------------------");
                writer.println();
                writer.println();
                ++i;
            }
        }
    }

    public void discard() {
    }

    public boolean isDiscarded() {
        return this.discarded;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public TestStepResult getOriginalTestStepResult() {
        return this.originalTestStepResult;
    }

    public void setOriginalTestStepResult(TestStepResult originalTestStepResult) {
        this.originalTestStepResult = originalTestStepResult;
    }

    public TestStep getTestStep() {
        return this.testStep;
    }

    public String getSecurityTestLog() {
        StringBuffer tl = new StringBuffer().append("Step ").append(" [").append(this.testStep.getName()).append("] ").append(this.getExecutionProgressStatus().toString()).append(": took ").append(this.getOriginalTestStepResult().getTimeTaken()).append(" ms");
        tl.append(this.testLog);
        return tl.toString();
    }

    @Override
    public String getResultType() {
        return TYPE;
    }

    @Override
    public SecurityResult.ResultStatus getExecutionProgressStatus() {
        return this.executionProgressStatus;
    }

    public void setExecutionProgressStatus(SecurityResult.ResultStatus status) {
        this.executionProgressStatus = status;
    }

    @Override
    public SecurityResult.ResultStatus getLogIconStatus() {
        return this.logIconStatus;
    }

    public String getSecurityTestStepName() {
        return this.getTestStep().getName();
    }

    public String getLogIconStatusString() {
        return this.logIconStatus.toString();
    }

    public String getStatusString() {
        return this.status.toString();
    }

    public void release() {
        if (this.securityScanResultList != null) {
            this.securityScanResultList.clear();
        }
    }
}

