/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security;

import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.model.security.SecurityScan;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.security.SecurityTestRunnerImpl;
import com.eviware.soapui.security.result.SecurityTestStepResult;
import com.eviware.soapui.support.types.StringToObjectMap;

public class SecurityTestRunContext
extends WsdlTestRunContext {
    private int currentScanIndex;
    private TestStepResult originalTestStepResult;
    private int currentScanOnSecurityTestIndex;
    private SecurityTest securityTest;
    private SecurityTestStepResult currentSecurityStepResult;

    public SecurityTestRunContext(TestCaseRunner testRunner, StringToObjectMap properties) {
        super(testRunner, properties, ((SecurityTestRunnerImpl)testRunner).getSecurityTest());
        if (testRunner instanceof SecurityTestRunnerImpl) {
            this.securityTest = ((SecurityTestRunnerImpl)testRunner).getSecurityTest();
        }
    }

    public int getCurrentScanOnSecurityTestIndex() {
        return this.currentScanOnSecurityTestIndex;
    }

    public void setCurrentScanOnSecurityTestIndex(int currentScanOnSecurityTestIndex) {
        this.currentScanOnSecurityTestIndex = currentScanOnSecurityTestIndex;
    }

    public int getCurrentScanIndex() {
        return this.currentScanIndex;
    }

    public void setCurrentScanIndex(int currentScanIndex) {
        this.currentScanIndex = currentScanIndex;
    }

    @Override
    public Object get(Object key) {
        if ("currentStep".equals(key)) {
            return this.getCurrentStep();
        }
        if ("currentStepIndex".equals(key)) {
            return this.getCurrentStepIndex();
        }
        if ("settings".equals(key)) {
            return this.getSettings();
        }
        if ("testCase".equals(key)) {
            return this.getTestCase();
        }
        if ("testRunner".equals(key)) {
            return this.getTestRunner();
        }
        Object result = this.getProperty(key.toString());
        if (result == null) {
            result = super.get(key);
        }
        return result;
    }

    public void setCurrentSecurityStepResult(SecurityTestStepResult result) {
        this.currentSecurityStepResult = result;
    }

    public SecurityTestStepResult getCurrentSecurityStepResult() {
        return this.currentSecurityStepResult;
    }

    protected TestStepResult getOriginalTestStepResult() {
        return this.originalTestStepResult;
    }

    protected void setOriginalTestStepResult(TestStepResult originalTestStepResult) {
        this.originalTestStepResult = originalTestStepResult;
    }

    public SecurityScan getCurrentScan() {
        int testStepScanCount = 0;
        if (this.securityTest != null) {
            testStepScanCount = this.securityTest.getSecurityScanCount();
        }
        if (this.currentScanIndex < 0 || this.currentScanIndex >= testStepScanCount) {
            return null;
        }
        if (this.securityTest != null) {
            return this.securityTest.getTestStepSecurityScanAt(this.getCurrentStep().getId(), this.getCurrentScanIndex());
        }
        return null;
    }
}

