/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.plugins;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.plugins.InstalledPluginRecord;
import com.eviware.soapui.plugins.JarClassLoader;
import com.eviware.soapui.plugins.MissingPluginClassException;
import com.eviware.soapui.plugins.Plugin;
import com.eviware.soapui.plugins.PluginDependencyResolver;
import com.eviware.soapui.plugins.PluginId;
import com.eviware.soapui.plugins.PluginInfo;
import com.eviware.soapui.plugins.PluginListener;
import com.eviware.soapui.plugins.PluginLoader;
import com.eviware.soapui.plugins.ProductBodyguard;
import com.eviware.soapui.plugins.UninstallablePlugin;
import com.eviware.soapui.plugins.Version;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.SoapUIActionRegistry;
import com.eviware.soapui.support.factory.SoapUIFactoryRegistry;
import com.eviware.soapui.support.listener.ListenerRegistry;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class PluginManager {
    FileOperations fileOperations = new DefaultFileOperations();
    PluginLoader pluginLoader;
    private static Logger log = Logger.getLogger(PluginManager.class);
    private Map<File, InstalledPluginRecord> installedPlugins = new HashMap<File, InstalledPluginRecord>();
    private File pluginDirectory;
    private List<PluginListener> listeners = new ArrayList<PluginListener>();
    private final File pluginDeleteListFile;
    private PluginDependencyResolver resolver;
    private static ForkJoinPool forkJoinPool = new ForkJoinPool(Runtime.getRuntime().availableProcessors(), ForkJoinPool.defaultForkJoinWorkerThreadFactory, new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            System.err.println("Problem running task in the forkJoinPool");
            e.printStackTrace();
        }
    }, false);

    public PluginManager(SoapUIFactoryRegistry factoryRegistry, SoapUIActionRegistry actionRegistry, ListenerRegistry listenerRegistry) {
        this.pluginLoader = new PluginLoader(factoryRegistry, actionRegistry, listenerRegistry);
        File soapUiDirectory = new File(System.getProperty("user.home"), ".soapuios");
        this.pluginDirectory = new File(soapUiDirectory, "plugins");
        if (!this.pluginDirectory.exists() && !this.pluginDirectory.mkdirs()) {
            log.error((Object)("Couldn't create plugin directory in location " + this.pluginDirectory.getAbsolutePath()));
        }
        this.pluginDeleteListFile = new File(this.pluginDirectory, "delete_files.txt");
        if (this.pluginDeleteListFile.exists()) {
            this.deleteOldPluginFiles();
        }
    }

    public PluginLoader getPluginLoader() {
        return this.pluginLoader;
    }

    public static ForkJoinPool getForkJoinPool() {
        return forkJoinPool;
    }

    public void loadPlugins() {
        File[] pluginFiles = this.pluginDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && (pathname.getName().toLowerCase().endsWith(".jar") || pathname.getName().toLowerCase().endsWith(".zip"));
            }
        });
        if (pluginFiles != null) {
            List<File> pluginFileList = new ArrayList<File>();
            ProductBodyguard productBodyguard = new ProductBodyguard();
            for (File f : pluginFiles) {
                if (!productBodyguard.isKnown(f)) {
                    SoapUI.log.warn((Object)("Plugin '" + f.getName() + "' is not loaded because it hasn't been signed by SmartBear Software."));
                    continue;
                }
                pluginFileList.add(f);
            }
            this.resolver = null;
            try {
                this.resolver = new PluginDependencyResolver(this.pluginLoader, pluginFileList);
                pluginFileList = this.resolver.determineLoadOrder();
            }
            catch (Exception e) {
                log.error((Object)"Couldn't resolve plugin dependency order. This may impair plugin functionality.", (Throwable)e);
            }
            long startTime = System.currentTimeMillis();
            PluginManager.getForkJoinPool().invoke(new LoadPluginsTask(pluginFileList));
            long timeTaken = System.currentTimeMillis() - startTime;
            log.info((Object)(pluginFileList.size() + " plugins loaded in " + timeTaken + " ms"));
        }
    }

    private Collection<JarClassLoader> findDependentClassLoaders(File pluginFile) throws IOException {
        if (this.resolver == null) {
            return Collections.emptySet();
        }
        Collection<PluginInfo> allDependencies = this.resolver.findAllDependencies(pluginFile);
        HashSet<JarClassLoader> classLoaders = new HashSet<JarClassLoader>();
        block0: for (PluginInfo dependency : allDependencies) {
            for (InstalledPluginRecord installedPluginRecord : this.installedPlugins.values()) {
                if (!installedPluginRecord.plugin.getInfo().isCompatibleWith(dependency)) continue;
                classLoaders.add(installedPluginRecord.pluginClassLoader);
                continue block0;
            }
        }
        return classLoaders;
    }

    private Plugin doInstallPlugin(File pluginFile, Collection<JarClassLoader> classLoaders) throws IOException {
        UISupport.addResourceClassLoader(new URLClassLoader(new URL[]{pluginFile.toURI().toURL()}));
        InstalledPluginRecord context = this.pluginLoader.loadPlugin(pluginFile, classLoaders);
        this.installedPlugins.put(pluginFile, context);
        for (PluginListener listener : this.listeners) {
            listener.pluginLoaded(context.plugin);
        }
        return context.plugin;
    }

    public Plugin installPlugin(File pluginFile) throws IOException {
        PluginInfo pluginInfo = this.pluginLoader.loadPluginInfoFrom(pluginFile, Collections.emptySet());
        if (this.findInstalledVersionOf(pluginInfo) != null && !this.overwriteConfirmed(pluginInfo)) {
            return null;
        }
        File destinationFile = new File(this.pluginDirectory, pluginFile.getName());
        if (destinationFile.exists()) {
            destinationFile = this.createNonExistingFileName(destinationFile);
        }
        this.fileOperations.copyFile(pluginFile, destinationFile);
        this.resolver.addPlugin(pluginInfo, destinationFile);
        if (this.uninstallPlugin(pluginInfo, true)) {
            return this.doInstallPlugin(destinationFile, this.findDependentClassLoaders(destinationFile));
        }
        return null;
    }

    private File createNonExistingFileName(File fileToWrite) {
        String originalFileName = fileToWrite.getName();
        String newFileName = null;
        if (originalFileName.matches(".+\\-\\d+\\.jar")) {
            while (newFileName == null || new File(this.pluginDirectory, newFileName).exists()) {
                int lastDashIndex = originalFileName.lastIndexOf(45);
                int fileCountIndex = Integer.parseInt(originalFileName.substring(lastDashIndex + 1, originalFileName.length() - 4));
                newFileName = originalFileName.substring(0, lastDashIndex + 1) + (fileCountIndex + 1) + ".jar";
            }
        } else {
            newFileName = originalFileName.substring(0, originalFileName.length() - 4) + "-2.jar";
        }
        return new File(this.pluginDirectory, newFileName);
    }

    private boolean overwriteConfirmed(PluginInfo pluginInfo) {
        PluginInfo installedPluginInfo = this.findInstalledVersionOf(pluginInfo).getInfo();
        return UISupport.confirm("You currently have version " + installedPluginInfo.getVersion() + " of the plugin " + pluginInfo.getId().getName() + " installed.\nDo you want to overwrite it with version " + pluginInfo.getVersion() + " of the same plugin?", "Overwrite plugin");
    }

    private Plugin findInstalledVersionOf(PluginInfo pluginInfo) {
        for (InstalledPluginRecord installedPlugin : this.installedPlugins.values()) {
            if (!installedPlugin.plugin.getInfo().getId().equals(pluginInfo.getId())) continue;
            return installedPlugin.plugin;
        }
        return null;
    }

    public boolean uninstallPlugin(Plugin plugin) throws IOException {
        return this.uninstallPlugin(plugin.getInfo(), false);
    }

    public boolean uninstallPlugin(PluginInfo pluginInfo, boolean silent) throws IOException {
        for (File installedPluginFile : this.installedPlugins.keySet()) {
            Plugin installedPlugin = this.installedPlugins.get((Object)installedPluginFile).plugin;
            if (!installedPlugin.getInfo().getId().equals(pluginInfo.getId())) continue;
            if (!this.fileOperations.deleteFile(installedPluginFile)) {
                log.warn((Object)("Couldn't delete old plugin file " + installedPluginFile + " - aborting uninstall"));
                return false;
            }
            String uninstallMessage = "Plugin uninstalled - you should restart SoapUI to ensure that the changes to take effect";
            if (installedPlugin instanceof UninstallablePlugin) {
                try {
                    boolean uninstalled = ((UninstallablePlugin)installedPlugin).uninstall();
                    if (uninstalled) {
                        uninstallMessage = "Plugin uninstalled successfully";
                    }
                }
                catch (Exception e) {
                    if (silent) {
                        log.error((Object)"Error while uninstalling plugin", (Throwable)e);
                    } else {
                        UISupport.showErrorMessage("The plugin file has been deleted but could not be uninstalled - restart SoapUI for the changes to take effect");
                    }
                    return false;
                }
            }
            try {
                this.pluginLoader.unloadPlugin(installedPlugin);
                for (PluginListener listener : this.listeners) {
                    listener.pluginUnloaded(installedPlugin);
                }
            }
            catch (Exception e) {
                uninstallMessage = "Plugin unloaded unsuccessfully - please restart";
                log.error((Object)"Couldn't unload plugin", (Throwable)e);
            }
            this.installedPlugins.remove(installedPluginFile);
            this.resolver.removePlugin(pluginInfo);
            if (silent) break;
            UISupport.showInfoMessage(uninstallMessage);
            break;
        }
        return true;
    }

    public Collection<Plugin> getInstalledPlugins() {
        HashSet<Plugin> plugins = new HashSet<Plugin>();
        for (InstalledPluginRecord installedPluginRecord : this.installedPlugins.values()) {
            plugins.add(installedPluginRecord.plugin);
        }
        return Collections.unmodifiableCollection(plugins);
    }

    public void addPluginListener(PluginListener listener) {
        this.listeners.add(listener);
    }

    public void removePluginListener(PluginListener listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteOldPluginFiles() {
        try {
            List filesToDelete = FileUtils.readLines((File)this.pluginDeleteListFile);
            for (String fileName : filesToDelete) {
                File oldPluginFile = new File(this.pluginDirectory, fileName.trim());
                if (oldPluginFile.exists()) {
                    if (oldPluginFile.delete()) continue;
                    log.warn((Object)("Couldn't delete old plugin file " + fileName + " on startup"));
                    continue;
                }
                log.info((Object)("Old plugin file not found: " + fileName));
            }
        }
        catch (IOException e) {
            log.error((Object)("Couldn't read list of old plugin files to delete from file " + this.pluginDeleteListFile.getAbsolutePath()));
        }
        finally {
            if (!this.pluginDeleteListFile.delete()) {
                log.warn((Object)"Couldn't remove file with list of old plugin files to delete");
            }
        }
    }

    private List<PluginInfo> findUnsatisfiedDependencies(PluginInfo pluginInfo) {
        ArrayList<PluginInfo> unsatisfiedDependencies = new ArrayList<PluginInfo>();
        for (PluginInfo dependency : pluginInfo.getDependencies()) {
            if (this.dependencyInstalled(dependency)) continue;
            unsatisfiedDependencies.add(dependency);
        }
        return unsatisfiedDependencies;
    }

    private boolean dependencyInstalled(PluginInfo dependency) {
        for (Plugin plugin : this.getInstalledPlugins()) {
            PluginId dependencyId = dependency.getId();
            Version minimumVersion = dependency.getVersion();
            if (!plugin.getInfo().getId().equals(dependencyId) || plugin.getInfo().getVersion().compareTo(minimumVersion) == -1) continue;
            return true;
        }
        return false;
    }

    public void installPlugins(List<File> pluginFilesToInstall) throws IOException {
        PluginDependencyResolver downloadsResolver = new PluginDependencyResolver(this.pluginLoader, pluginFilesToInstall);
        for (File file : downloadsResolver.determineLoadOrder()) {
            this.installPlugin(file);
        }
    }

    public Collection<Plugin> getDependentPlugins(Plugin selectedPlugin) {
        HashSet<Plugin> dependentPlugins = new HashSet<Plugin>();
        block0: for (InstalledPluginRecord installedPluginRecord : this.installedPlugins.values()) {
            Collection<PluginInfo> allDependencies = this.resolver.findAllDependencies(installedPluginRecord.plugin.getInfo());
            for (PluginInfo dependency : allDependencies) {
                if (!dependency.isCompatibleWith(selectedPlugin.getInfo())) continue;
                dependentPlugins.add(installedPluginRecord.plugin);
                continue block0;
            }
        }
        return dependentPlugins;
    }

    private class LoadPluginsTask
    extends RecursiveTask<List<Plugin>> {
        private List<File> files;

        private LoadPluginsTask(Collection<File> files) {
            this.files = new ArrayList<File>(files);
        }

        @Override
        protected List<Plugin> compute() {
            int splitPoint = this.findSplitPoint(this.files.size() / 2);
            if (splitPoint == 0 || splitPoint == this.files.size() - 1) {
                return this.computeSequentially();
            }
            LoadPluginsTask leftTask = new LoadPluginsTask(this.files.subList(0, splitPoint));
            leftTask.fork();
            LoadPluginsTask rightTask = new LoadPluginsTask(this.files.subList(splitPoint, this.files.size()));
            Object rightTaskResult = rightTask.compute();
            List leftTaskResult = (List)leftTask.join();
            ArrayList<Plugin> result = new ArrayList<Plugin>();
            result.addAll(leftTaskResult);
            result.addAll((Collection<Plugin>)rightTaskResult);
            return result;
        }

        private int findSplitPoint(int tentativeSplitPoint) {
            if (tentativeSplitPoint <= 0) {
                return 0;
            }
            if (tentativeSplitPoint >= this.files.size() - 1) {
                return this.files.size() - 1;
            }
            List<PluginInfo> pluginInfoList = PluginManager.this.resolver.getPluginInfoListFromFiles(this.files);
            if (pluginInfoList.get(tentativeSplitPoint + 1).getDependencies().isEmpty()) {
                return tentativeSplitPoint;
            }
            int leftSplitPoint = this.findSplitPoint(tentativeSplitPoint - 1);
            int rightSplitPoint = this.findSplitPoint(tentativeSplitPoint + 1);
            if (leftSplitPoint > 0 && tentativeSplitPoint - leftSplitPoint <= rightSplitPoint - tentativeSplitPoint) {
                return leftSplitPoint;
            }
            if (rightSplitPoint < this.files.size() - 1) {
                return rightSplitPoint;
            }
            return 0;
        }

        private List<Plugin> computeSequentially() {
            ArrayList<Plugin> result = new ArrayList<Plugin>();
            for (File pluginFile : this.files) {
                try {
                    log.info((Object)("Adding plugin from [" + pluginFile.getAbsolutePath() + "]"));
                    try {
                        Plugin plugin = PluginManager.this.doInstallPlugin(pluginFile, PluginManager.this.findDependentClassLoaders(pluginFile));
                        result.add(plugin);
                    }
                    catch (MissingPluginClassException e) {
                        log.error((Object)("No plugin found in [" + pluginFile + "]"));
                    }
                    catch (Exception e) {
                        log.warn((Object)("Could not load plugin from file [" + pluginFile + "]"), (Throwable)e);
                    }
                }
                catch (Throwable e) {
                    log.error((Object)("Failed to load module [" + pluginFile.getName() + "]"), e);
                }
            }
            return result;
        }
    }

    static interface FileOperations {
        public void copyFile(File var1, File var2) throws IOException;

        public boolean deleteFile(File var1) throws IOException;
    }

    private class DefaultFileOperations
    implements FileOperations {
        private DefaultFileOperations() {
        }

        @Override
        public void copyFile(File sourceFile, File destinationFile) throws IOException {
            FileUtils.copyFile((File)sourceFile, (File)destinationFile);
        }

        @Override
        public boolean deleteFile(File fileToDelete) throws IOException {
            if (!fileToDelete.delete()) {
                try {
                    FileUtils.write((File)PluginManager.this.pluginDeleteListFile, (CharSequence)(fileToDelete.getName() + "\r\n"), (boolean)true);
                }
                catch (IOException e) {
                    log.error((Object)("Couldn't schedule plugin file " + fileToDelete.getName() + " for deletion"), (Throwable)e);
                    return false;
                }
            }
            return true;
        }
    }
}

