/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.plugins;

import com.eviware.soapui.plugins.PluginId;
import com.eviware.soapui.plugins.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PluginInfo {
    private final PluginId id;
    private final Version version;
    private final String description;
    private final String infoUrl;
    private List<PluginInfo> dependencies = new ArrayList<PluginInfo>();

    public PluginInfo(PluginId id, Version version, String description, String infoUrl) {
        this.id = id;
        this.version = version;
        this.description = description;
        this.infoUrl = infoUrl;
    }

    public PluginId getId() {
        return this.id;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInfoUrl() {
        return this.infoUrl;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != PluginInfo.class) {
            return false;
        }
        PluginInfo other = (PluginInfo)obj;
        return other.id.equals(this.id) && other.version.equals(this.version);
    }

    public int hashCode() {
        return 17 * this.id.hashCode() + this.version.hashCode();
    }

    public void addDependency(PluginInfo pluginInfo) {
        this.dependencies.add(pluginInfo);
    }

    public List<PluginInfo> getDependencies() {
        return Collections.unmodifiableList(this.dependencies);
    }

    public boolean isCompatibleWith(PluginInfo pluginInfo) {
        return this.id.equals(pluginInfo.id) && this.version.compareTo(pluginInfo.version) >= 0;
    }
}

