/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.support;

import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class ModelSupport {
    public static <T extends ModelItem> String[] getNames(List<T> list) {
        String[] names = new String[list.size()];
        for (int c = 0; c < names.length; ++c) {
            names[c] = ((ModelItem)list.get(c)).getName();
        }
        return names;
    }

    public static <T extends ModelItem> List<T> getChildren(ModelItem modelItem, Class<T> childType) {
        ArrayList<ModelItem> result = new ArrayList<ModelItem>();
        for (ModelItem modelItem2 : modelItem.getChildren()) {
            if (!modelItem2.getClass().equals(childType)) continue;
            result.add(modelItem2);
        }
        return result;
    }

    public static <T extends ModelItem> String[] getNames(List<T> list, ModelItemFilter<T> filter) {
        String[] names = new String[list.size()];
        for (int c = 0; c < names.length; ++c) {
            if (filter != null && !filter.accept((ModelItem)list.get(c))) continue;
            names[c] = ((ModelItem)list.get(c)).getName();
        }
        return names;
    }

    public static String[] getNames(String[] firstItems, List<? extends ModelItem> list) {
        int c;
        String[] names = new String[list.size() + firstItems.length];
        for (c = 0; c < firstItems.length; ++c) {
            names[c] = firstItems[c];
        }
        for (c = 0; c < list.size(); ++c) {
            names[c + firstItems.length] = list.get(c).getName();
        }
        return names;
    }

    public static String[] getNames(List<? extends ModelItem> list, String[] lastItems) {
        int c;
        String[] names = new String[list.size() + lastItems.length];
        for (c = 0; c < lastItems.length; ++c) {
            names[c + list.size()] = lastItems[c];
        }
        for (c = 0; c < list.size(); ++c) {
            names[c] = list.get(c).getName();
        }
        return names;
    }

    public static String generateModelItemID() {
        return UUID.randomUUID().toString();
    }

    public static <T extends ModelItem> T findModelItemById(String id, ModelItem root) {
        if (root == null || id == null) {
            return null;
        }
        for (ModelItem modelItem : root.getChildren()) {
            if (modelItem.getId().equals(id)) {
                return (T)modelItem;
            }
            T result = ModelSupport.findModelItemById(id, modelItem);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static String promptForUniqueName(String typeName, ModelItem parent, String def) {
        String name = UISupport.prompt("Specify name for new " + typeName, "New " + typeName, def);
        StringList names = new StringList();
        for (ModelItem modelItem : parent.getChildren()) {
            names.add(modelItem.getName());
        }
        while (name != null && names.contains(name)) {
            name = UISupport.prompt("Specify unique name for new " + typeName, "New " + typeName, def);
        }
        return name;
    }

    public static Project getModelItemProject(ModelItem modelItem) {
        if (modelItem == null) {
            return null;
        }
        while (!(modelItem instanceof Project) && modelItem != null) {
            modelItem = modelItem.getParent();
        }
        return (Project)modelItem;
    }

    public static TestCase getModelItemTestCase(ModelItem modelItem) {
        if (modelItem == null) {
            return null;
        }
        while (!(modelItem instanceof TestCase) && modelItem != null) {
            modelItem = modelItem.getParent();
        }
        return (TestCase)modelItem;
    }

    public static String getResourceRoot(AbstractWsdlModelItem<?> testStep) {
        WsdlProject project = (WsdlProject)ModelSupport.getModelItemProject(testStep);
        if (project == null) {
            return null;
        }
        return PropertyExpander.expandProperties(project, project.getResourceRoot());
    }

    public static void createNewIds(AbstractWsdlModelItem<?> modelItem) {
        if (modelItem.getConfig().isSetId()) {
            modelItem.getConfig().setId(ModelSupport.generateModelItemID());
        }
        for (ModelItem modelItem2 : modelItem.getChildren()) {
            if (!(modelItem2 instanceof AbstractWsdlModelItem)) continue;
            ModelSupport.createNewIds((AbstractWsdlModelItem)modelItem2);
        }
    }

    public static void unsetIds(AbstractWsdlModelItem<?>[] modelItems) {
        for (AbstractWsdlModelItem<?> modelItem : modelItems) {
            ModelSupport.createNewIds(modelItem);
        }
    }

    public static boolean dependsOn(ModelItem source, ModelItem target) {
        if (source == target) {
            return true;
        }
        for (ModelItem p = source.getParent(); p != null; p = p.getParent()) {
            if (p != target) continue;
            return true;
        }
        return false;
    }

    public static boolean isOneOf(ModelItem modelItem, Object ... classes) {
        for (Object clazz : classes) {
            if (clazz instanceof Class && ((Class)clazz).isAssignableFrom(modelItem.getClass())) {
                return true;
            }
            if (!(clazz instanceof ModelItem) || !clazz.getClass().isAssignableFrom(modelItem.getClass())) continue;
            return true;
        }
        return false;
    }

    public static class InterfaceTypeFilter
    implements ModelItemFilter<Interface> {
        private String type;

        public InterfaceTypeFilter(String type) {
            this.type = type;
        }

        @Override
        public boolean accept(Interface modelItem) {
            return modelItem.getInterfaceType().equals(this.type);
        }
    }

    public static interface ModelItemFilter<T extends ModelItem> {
        public boolean accept(T var1);
    }
}

