/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.propertyexpansion.resolvers;

import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.propertyexpansion.resolvers.PropertyResolver;
import com.eviware.soapui.model.propertyexpansion.resolvers.ResolverUtils;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.support.types.StringList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlString;

public class GlobalPropertyResolver
implements PropertyResolver {
    private SystemPropertyHolder systemPropertyHolder = new SystemPropertyHolder();
    private EnvironmentPropertyHolder environmentPropertyHolder = new EnvironmentPropertyHolder();

    @Override
    public String resolveProperty(PropertyExpansionContext context, String name, boolean globalOverride) {
        String result = ResolverUtils.checkForExplicitReference(name, "#Global#", PropertyExpansionUtils.getGlobalProperties(), context, false);
        if (result != null) {
            return result;
        }
        result = ResolverUtils.checkForExplicitReference(name, "#System#", this.systemPropertyHolder, context, globalOverride);
        if (result != null) {
            return result;
        }
        result = ResolverUtils.checkForExplicitReference(name, "#Env#", this.environmentPropertyHolder, context, globalOverride);
        if (result != null) {
            return result;
        }
        if (name.length() > 2 && name.charAt(0) == '#' && name.charAt(1) == '#') {
            return PropertyExpansionUtils.getGlobalProperty(name.substring(2));
        }
        return PropertyExpansionUtils.getGlobalProperty(name);
    }

    public class SystemPropertyHolder
    implements TestPropertyHolder {
        @Override
        public void addTestPropertyListener(TestPropertyListener listener) {
        }

        @Override
        public ModelItem getModelItem() {
            return null;
        }

        @Override
        public Map<String, TestProperty> getProperties() {
            Properties properties = System.getProperties();
            HashMap<String, TestProperty> result = new HashMap<String, TestProperty>();
            for (Object key : properties.keySet()) {
                result.put(key.toString(), new SystemTestProperty(key));
            }
            return result;
        }

        @Override
        public String getPropertiesLabel() {
            return "System Properties";
        }

        @Override
        public TestProperty getProperty(String name) {
            Properties properties = System.getProperties();
            return properties.containsKey(name) ? new SystemTestProperty(name) : null;
        }

        @Override
        public TestProperty getPropertyAt(int index) {
            return this.getProperty(this.getPropertyNames()[index]);
        }

        @Override
        public int getPropertyCount() {
            return System.getProperties().size();
        }

        @Override
        public List<TestProperty> getPropertyList() {
            ArrayList<TestProperty> result = new ArrayList<TestProperty>();
            for (TestProperty property : this.getProperties().values()) {
                result.add(property);
            }
            return result;
        }

        @Override
        public String[] getPropertyNames() {
            Set<Object> keys = System.getProperties().keySet();
            StringList result = new StringList();
            for (Object key : keys) {
                result.add(key.toString());
            }
            return result.toStringArray();
        }

        @Override
        public String getPropertyValue(String name) {
            TestProperty property = this.getProperty(name);
            return property == null ? null : property.getValue();
        }

        @Override
        public boolean hasProperty(String name) {
            return System.getProperties().containsKey(name);
        }

        @Override
        public void removeTestPropertyListener(TestPropertyListener listener) {
        }

        @Override
        public void setPropertyValue(String name, String value) {
            System.setProperty(name, value);
        }

        private class SystemTestProperty
        implements TestProperty {
            private final Object key;

            public SystemTestProperty(Object key) {
                this.key = key;
            }

            @Override
            public String getDefaultValue() {
                return null;
            }

            @Override
            public String getDescription() {
                return null;
            }

            @Override
            public ModelItem getModelItem() {
                return null;
            }

            @Override
            public String getName() {
                return this.key.toString();
            }

            @Override
            public QName getType() {
                return XmlString.type.getName();
            }

            @Override
            public String getValue() {
                return System.getProperty(this.key.toString());
            }

            @Override
            public boolean isReadOnly() {
                return false;
            }

            @Override
            public void setValue(String value) {
                System.setProperty(this.key.toString(), value);
            }

            @Override
            public boolean isRequestPart() {
                return false;
            }

            @Override
            public SchemaType getSchemaType() {
                return XmlBeans.getBuiltinTypeSystem().findType(this.getType());
            }
        }
    }

    public class EnvironmentPropertyHolder
    implements TestPropertyHolder {
        @Override
        public void addTestPropertyListener(TestPropertyListener listener) {
        }

        @Override
        public ModelItem getModelItem() {
            return null;
        }

        @Override
        public Map<String, TestProperty> getProperties() {
            Map<String, String> properties = System.getenv();
            HashMap<String, TestProperty> result = new HashMap<String, TestProperty>();
            for (String key : properties.keySet()) {
                result.put(key.toString(), new SystemEnviromentTestProperty(key));
            }
            return result;
        }

        @Override
        public List<TestProperty> getPropertyList() {
            ArrayList<TestProperty> result = new ArrayList<TestProperty>();
            for (TestProperty property : this.getProperties().values()) {
                result.add(property);
            }
            return result;
        }

        @Override
        public String getPropertiesLabel() {
            return "Environment Properties";
        }

        @Override
        public TestProperty getProperty(String name) {
            Map<String, String> properties = System.getenv();
            return properties.containsKey(name) ? new SystemEnviromentTestProperty(name) : null;
        }

        @Override
        public TestProperty getPropertyAt(int index) {
            return this.getProperty(this.getPropertyNames()[index]);
        }

        @Override
        public int getPropertyCount() {
            return System.getenv().size();
        }

        @Override
        public String[] getPropertyNames() {
            Set<String> keys = System.getenv().keySet();
            StringList result = new StringList();
            for (String key : keys) {
                result.add(key.toString());
            }
            return result.toStringArray();
        }

        @Override
        public String getPropertyValue(String name) {
            TestProperty property = this.getProperty(name);
            return property == null ? null : property.getValue();
        }

        @Override
        public boolean hasProperty(String name) {
            return System.getenv().containsKey(name);
        }

        @Override
        public void removeTestPropertyListener(TestPropertyListener listener) {
        }

        @Override
        public void setPropertyValue(String name, String value) {
        }

        private class SystemEnviromentTestProperty
        implements TestProperty {
            private final Object key;

            public SystemEnviromentTestProperty(Object key) {
                this.key = key;
            }

            @Override
            public String getDefaultValue() {
                return null;
            }

            @Override
            public String getDescription() {
                return null;
            }

            @Override
            public ModelItem getModelItem() {
                return null;
            }

            @Override
            public String getName() {
                return this.key.toString();
            }

            @Override
            public QName getType() {
                return XmlString.type.getName();
            }

            @Override
            public String getValue() {
                return System.getenv(this.key.toString());
            }

            @Override
            public boolean isReadOnly() {
                return true;
            }

            @Override
            public void setValue(String value) {
            }

            @Override
            public boolean isRequestPart() {
                return false;
            }

            @Override
            public SchemaType getSchemaType() {
                return XmlBeans.getBuiltinTypeSystem().findType(this.getType());
            }
        }
    }
}

