/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.propertyexpansion;

import com.eviware.soapui.model.propertyexpansion.MutablePropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionImpl;
import com.eviware.soapui.model.testsuite.TestProperty;
import org.apache.commons.beanutils.PropertyUtils;

public class MutablePropertyExpansionImpl
extends PropertyExpansionImpl
implements MutablePropertyExpansion {
    private final Object container;
    private final String propertyName;
    private String stringRep;

    public MutablePropertyExpansionImpl(TestProperty tp, String xpath, Object container, String propertyName) {
        super(tp, xpath);
        this.container = container;
        this.propertyName = propertyName;
        this.stringRep = this.toString();
    }

    @Override
    public void setProperty(TestProperty property) {
        super.setProperty(property);
    }

    @Override
    public void setXPath(String xpath) {
        super.setXPath(xpath);
    }

    @Override
    public void update() throws Exception {
        String rep = this.toString();
        if (this.stringRep.equals(rep)) {
            return;
        }
        Object obj = PropertyUtils.getProperty((Object)this.container, (String)this.propertyName);
        if (obj == null) {
            throw new Exception("property value is null");
        }
        String str = obj.toString();
        int ix = str.indexOf(this.stringRep);
        if (ix == -1) {
            throw new Exception("property expansion [" + this.stringRep + "] not found for update");
        }
        while (ix != -1) {
            str = str.substring(0, ix) + rep + str.substring(ix + this.stringRep.length());
            ix = str.indexOf(this.stringRep, ix + rep.length());
        }
        PropertyUtils.setProperty((Object)this.container, (String)this.propertyName, (Object)str);
        this.stringRep = rep;
    }
}

