/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.config.GotoConditionConfig;
import com.eviware.soapui.config.GotoConditionTypeConfig;
import com.eviware.soapui.config.GotoStepConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.support.http.HttpRequestTestStep;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.TestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepWithProperties;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContainer;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.support.XPathReference;
import com.eviware.soapui.model.support.XPathReferenceContainer;
import com.eviware.soapui.model.support.XPathReferenceImpl;
import com.eviware.soapui.model.testsuite.SamplerTestStep;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.XmlUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlBoolean;
import org.apache.xmlbeans.XmlObject;

public class WsdlGotoTestStep
extends WsdlTestStepWithProperties
implements XPathReferenceContainer,
PropertyExpansionContainer {
    private GotoStepConfig gotoStepConfig;
    private List<GotoCondition> conditions = new ArrayList<GotoCondition>();
    private boolean canceled;
    private static final Logger log = Logger.getLogger(WsdlGotoTestStep.class);

    public WsdlGotoTestStep(WsdlTestCase testCase, TestStepConfig config, boolean forLoadTest) {
        super(testCase, config, true, forLoadTest);
        if (!forLoadTest) {
            this.setIcon(UISupport.createImageIcon("/conditional_goto_step.png"));
        }
    }

    @Override
    public void afterLoad() {
        TestStepConfig config = (TestStepConfig)this.getConfig();
        if (config.getConfig() == null) {
            this.gotoStepConfig = (GotoStepConfig)config.addNewConfig().changeType(GotoStepConfig.type);
        } else {
            this.gotoStepConfig = (GotoStepConfig)config.getConfig().changeType(GotoStepConfig.type);
            for (int c = 0; c < this.gotoStepConfig.sizeOfConditionArray(); ++c) {
                this.conditions.add(new GotoCondition(this.gotoStepConfig.getConditionArray(c)));
            }
        }
        super.afterLoad();
    }

    @Override
    public void resetConfigOnMove(TestStepConfig config) {
        super.resetConfigOnMove(config);
        this.gotoStepConfig = (GotoStepConfig)config.getConfig().changeType(GotoStepConfig.type);
        for (int c = 0; c < this.gotoStepConfig.sizeOfConditionArray(); ++c) {
            this.conditions.get(c).setConfig(this.gotoStepConfig.getConditionArray(c));
        }
    }

    @Override
    public TestStepResult run(TestCaseRunner runner, TestCaseRunContext context) {
        WsdlTestStepResult result = new WsdlTestStepResult(this);
        this.canceled = false;
        result.startTimer();
        SamplerTestStep previousStep = this.getTestCase().findPreviousStepOfType(this, SamplerTestStep.class);
        if (previousStep == null) {
            result.stopTimer();
            result.addMessage("Failed to find previous request step from [" + this.getName() + "]");
            result.setStatus(TestStepResult.TestStepStatus.FAILED);
            return result;
        }
        GotoCondition target = this.runConditions(previousStep, context);
        if (target == null) {
            result.addMessage("Missing matching condition, moving on.");
        } else {
            String targetStepName = target.getTargetStep().trim();
            result.addMessage("Matched condition [" + targetStepName + "], transferring to [" + targetStepName + "]");
            runner.gotoStep(runner.getTestCase().getTestStepIndexByName(targetStepName));
        }
        result.stopTimer();
        result.setStatus(TestStepResult.TestStepStatus.OK);
        return result;
    }

    public GotoCondition runConditions(SamplerTestStep previousStep, TestCaseRunContext context) {
        for (GotoCondition condition : this.conditions) {
            if (this.canceled) break;
            try {
                if (!condition.evaluate(previousStep, context)) continue;
                return condition;
            }
            catch (Exception e) {
                log.error((Object)("Error making condition " + condition.getName() + "; " + e));
            }
        }
        return null;
    }

    @Override
    public boolean cancel() {
        this.canceled = true;
        return this.canceled;
    }

    public int getConditionCount() {
        return this.conditions.size();
    }

    public GotoCondition getConditionAt(int index) {
        return this.conditions.get(index);
    }

    public GotoCondition addCondition(String name) {
        GotoCondition condition = new GotoCondition(this.gotoStepConfig.addNewCondition());
        condition.setName(name);
        condition.setType(GotoConditionTypeConfig.XPATH.toString());
        this.conditions.add(condition);
        return condition;
    }

    public void removeConditionAt(int index) {
        this.conditions.remove(index);
        this.gotoStepConfig.removeCondition(index);
    }

    @Override
    public void release() {
        super.release();
        for (GotoCondition condition : this.conditions) {
            condition.release();
        }
    }

    @Override
    public boolean hasProperties() {
        return false;
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        ArrayList<? extends PropertyExpansion> result = new ArrayList<PropertyExpansion>();
        for (GotoCondition condition : this.conditions) {
            result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this, condition, "expression"));
        }
        return result.toArray(new PropertyExpansion[result.size()]);
    }

    @Override
    public XPathReference[] getXPathReferences() {
        ArrayList<XPathReferenceImpl> result = new ArrayList<XPathReferenceImpl>();
        for (GotoCondition condition : this.conditions) {
            if (!StringUtils.hasContent(condition.getExpression())) continue;
            result.add(new XPathReferenceImpl("Condition for " + condition.getName() + " GotoCondition in " + this.getName(), condition.getSourceProperty(), condition, "expression"));
        }
        return result.toArray(new XPathReference[result.size()]);
    }

    public class GotoCondition
    implements PropertyChangeListener {
        public static final String TARGET_STEP_PROPERTY = "target_step";
        private GotoConditionConfig conditionConfig;
        private TestStep currentStep;
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public GotoCondition(GotoConditionConfig conditionConfig) {
            this.conditionConfig = conditionConfig;
            this.initListeners();
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        private void initListeners() {
            int index;
            this.release();
            if (this.getTargetStep() != null && (index = WsdlGotoTestStep.this.getTestCase().getTestStepIndexByName(this.getTargetStep())) != -1) {
                this.currentStep = WsdlGotoTestStep.this.getTestCase().getTestStepAt(index);
                this.currentStep.addPropertyChangeListener(TestStep.NAME_PROPERTY, this);
            }
        }

        public void release() {
            if (this.currentStep != null) {
                this.currentStep.removePropertyChangeListener(this);
            }
        }

        public boolean evaluate(SamplerTestStep previousStep, TestCaseRunContext context) throws Exception {
            if (this.getExpression() == null || this.getExpression().trim().length() == 0) {
                throw new Exception("Missing expression in condition [" + this.getName() + "]");
            }
            if (this.getTargetStep() == null || this.getTargetStep().trim().length() == 0) {
                throw new Exception("Missing target step in condition [" + this.getName() + "]");
            }
            if (this.getType().equals(GotoConditionTypeConfig.XPATH.toString())) {
                String expression;
                TestRequest testRequest = previousStep.getTestRequest();
                XmlObject xmlObject = XmlUtils.createXmlObject(testRequest.getResponse().getContentAsXml());
                XmlObject[] selectPath = xmlObject.selectPath(expression = PropertyExpander.expandProperties(context, this.getExpression()));
                if (selectPath.length == 1 && selectPath[0] instanceof XmlBoolean && ((XmlBoolean)selectPath[0]).getBooleanValue()) {
                    return true;
                }
            } else {
                log.error((Object)("Unkown condition type: " + this.getType()));
            }
            return false;
        }

        protected void setConfig(GotoConditionConfig conditionConfig) {
            this.conditionConfig = conditionConfig;
        }

        public String getType() {
            return this.conditionConfig.getType();
        }

        public String getName() {
            return this.conditionConfig.getName();
        }

        public String getExpression() {
            return this.conditionConfig.getExpression();
        }

        public String getTargetStep() {
            return this.conditionConfig.getTargetStep();
        }

        public void setType(String type) {
            this.conditionConfig.setType(type);
        }

        public void setName(String name) {
            this.conditionConfig.setName(name);
        }

        public void setExpression(String expression) {
            this.conditionConfig.setExpression(expression);
        }

        public void setTargetStep(String targetStep) {
            String oldStep = this.getTargetStep();
            this.conditionConfig.setTargetStep(targetStep);
            this.initListeners();
            this.propertyChangeSupport.firePropertyChange(TARGET_STEP_PROPERTY, oldStep, targetStep);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.conditionConfig.setTargetStep(evt.getNewValue().toString());
            this.propertyChangeSupport.firePropertyChange(TARGET_STEP_PROPERTY, evt.getOldValue(), evt.getNewValue());
        }

        public TestProperty getSourceProperty() {
            HttpRequestTestStep previousStep = WsdlGotoTestStep.this.getTestCase().findPreviousStepOfType(WsdlGotoTestStep.this, HttpRequestTestStep.class);
            return previousStep == null ? null : previousStep.getProperty("Response");
        }
    }
}

