/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.RestRequestConfig;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertableConfig;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertionsSupport;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestInterface;
import com.eviware.soapui.impl.wsdl.teststeps.RestResponseMessageExchange;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequestInterface;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.TestAssertionRegistry;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionsListener;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.monitor.TestMonitor;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

public class RestTestRequest
extends RestRequest
implements RestTestRequestInterface {
    private ImageIcon validRequestIcon;
    private ImageIcon failedRequestIcon;
    private ImageIcon disabledRequestIcon;
    private ImageIcon unknownRequestIcon;
    private RestTestRequestStep testStep;
    private AssertionsSupport assertionsSupport;
    private RestResponseMessageExchange messageExchange;
    private final boolean forLoadTest;
    private PropertyChangeNotifier notifier;

    public RestTestRequest(RestMethod method, RestRequestConfig callConfig, RestTestRequestStep testStep, boolean forLoadTest) {
        super(method, callConfig, forLoadTest);
        this.forLoadTest = forLoadTest;
        this.setSettings(new XmlBeansSettingsImpl(this, testStep.getSettings(), callConfig.getSettings()));
        this.testStep = testStep;
        this.initAssertions();
        if (!forLoadTest) {
            this.initIcons();
        }
    }

    @Override
    public ModelItem getParent() {
        return this.getTestStep();
    }

    @Override
    public WsdlTestCase getTestCase() {
        return this.testStep.getTestCase();
    }

    protected void initIcons() {
        this.validRequestIcon = UISupport.createImageIcon("/valid_rest_request_step.png");
        this.failedRequestIcon = UISupport.createImageIcon("/invalid_rest_request_step.png");
        this.unknownRequestIcon = UISupport.createImageIcon("/rest_request_step.png");
        this.disabledRequestIcon = UISupport.createImageIcon("/disabled_rest_request_step.png");
        this.setIconAnimator(new TestRequestIconAnimator(this));
    }

    private void initAssertions() {
        this.assertionsSupport = new AssertionsSupport(this.testStep, new AssertableConfig(){

            @Override
            public TestAssertionConfig addNewAssertion() {
                return ((RestRequestConfig)RestTestRequest.this.getConfig()).addNewAssertion();
            }

            @Override
            public List<TestAssertionConfig> getAssertionList() {
                return ((RestRequestConfig)RestTestRequest.this.getConfig()).getAssertionList();
            }

            @Override
            public void removeAssertion(int ix) {
                ((RestRequestConfig)RestTestRequest.this.getConfig()).removeAssertion(ix);
            }

            @Override
            public TestAssertionConfig insertAssertion(TestAssertionConfig source, int ix) {
                TestAssertionConfig conf = ((RestRequestConfig)RestTestRequest.this.getConfig()).insertNewAssertion(ix);
                conf.set(source);
                return conf;
            }
        });
    }

    @Override
    public int getAssertionCount() {
        return this.assertionsSupport.getAssertionCount();
    }

    @Override
    public WsdlMessageAssertion getAssertionAt(int c) {
        return this.assertionsSupport.getAssertionAt(c);
    }

    @Override
    public void setResponse(HttpResponse response, SubmitContext context) {
        super.setResponse(response, context);
        this.assertResponse(context);
    }

    @Override
    public void assertResponse(SubmitContext context) {
        if (this.notifier == null) {
            this.notifier = new PropertyChangeNotifier();
        }
        RestResponseMessageExchange restResponseMessageExchange = this.messageExchange = this.getResponse() == null ? null : new RestResponseMessageExchange(this);
        if (this.messageExchange != null) {
            for (WsdlMessageAssertion assertion : this.assertionsSupport.getAssertionList()) {
                assertion.assertResponse(this.messageExchange, context);
            }
        }
        this.notifier.notifyChange();
    }

    @Override
    public WsdlMessageAssertion addAssertion(String assertionLabel) {
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        try {
            WsdlMessageAssertion assertion = this.assertionsSupport.addWsdlAssertion(assertionLabel);
            if (assertion == null) {
                return null;
            }
            if (this.getResponse() != null) {
                assertion.assertResponse(new RestResponseMessageExchange(this), new WsdlTestRunContext(this.testStep));
                notifier.notifyChange();
            }
            return assertion;
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAssertion(TestAssertion assertion) {
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        try {
            this.assertionsSupport.removeAssertion((WsdlMessageAssertion)assertion);
        }
        finally {
            ((WsdlMessageAssertion)assertion).release();
            notifier.notifyChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestAssertion moveAssertion(int ix, int offset) {
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        WsdlMessageAssertion assertion = this.getAssertionAt(ix);
        try {
            WsdlMessageAssertion wsdlMessageAssertion = this.assertionsSupport.moveAssertion(ix, offset);
            return wsdlMessageAssertion;
        }
        finally {
            assertion.release();
            notifier.notifyChange();
        }
    }

    @Override
    public Assertable.AssertionStatus getAssertionStatus() {
        if (this.messageExchange == null || this.getAssertionCount() == 0) {
            return Assertable.AssertionStatus.UNKNOWN;
        }
        for (int c = 0; c < this.getAssertionCount(); ++c) {
            if (this.getAssertionAt(c).getStatus() != Assertable.AssertionStatus.FAILED) continue;
            return Assertable.AssertionStatus.FAILED;
        }
        return Assertable.AssertionStatus.VALID;
    }

    @Override
    public ImageIcon getIcon() {
        if (this.forLoadTest || this.getIconAnimator() == null) {
            return null;
        }
        TestMonitor testMonitor = SoapUI.getTestMonitor();
        if (testMonitor != null && (testMonitor.hasRunningLoadTest(this.getTestStep().getTestCase()) || testMonitor.hasRunningSecurityTest(this.getTestStep().getTestCase()))) {
            return this.disabledRequestIcon;
        }
        ImageIcon icon = this.getIconAnimator().getIcon();
        if (icon == this.getIconAnimator().getBaseIcon()) {
            Assertable.AssertionStatus status = this.getAssertionStatus();
            if (status == Assertable.AssertionStatus.VALID) {
                return this.validRequestIcon;
            }
            if (status == Assertable.AssertionStatus.FAILED) {
                return this.failedRequestIcon;
            }
            if (status == Assertable.AssertionStatus.UNKNOWN) {
                return this.unknownRequestIcon;
            }
        }
        return icon;
    }

    @Override
    public void addAssertionsListener(AssertionsListener listener) {
        this.assertionsSupport.addAssertionsListener(listener);
    }

    @Override
    public void removeAssertionsListener(AssertionsListener listener) {
        this.assertionsSupport.removeAssertionsListener(listener);
    }

    @Override
    public void updateConfig(RestRequestConfig request) {
        super.updateConfig(request);
        this.assertionsSupport.refresh();
    }

    @Override
    public void release() {
        super.release();
        this.assertionsSupport.release();
        if (this.getRestMethod() != null) {
            this.getRestMethod().getResource().removePropertyChangeListener(this);
        }
        this.messageExchange = null;
    }

    @Override
    public String getAssertableContentAsXml() {
        return this.getResponseContentAsXml();
    }

    @Override
    public String getAssertableContent() {
        return this.getResponseContentAsString();
    }

    @Override
    public RestTestRequestStep getTestStep() {
        return this.testStep;
    }

    @Override
    public RestService getInterface() {
        return this.getOperation() == null ? null : this.getOperation().getInterface();
    }

    @Override
    public RestResource getOperation() {
        return this.testStep != null ? this.testStep.getResource() : null;
    }

    @Override
    public TestAssertionRegistry.AssertableType getAssertableType() {
        return TestAssertionRegistry.AssertableType.RESPONSE;
    }

    @Override
    public TestAssertion cloneAssertion(TestAssertion source, String name) {
        return this.assertionsSupport.cloneAssertion(source, name);
    }

    @Override
    public WsdlMessageAssertion importAssertion(WsdlMessageAssertion source, boolean overwrite2, boolean createCopy, String newName) {
        return this.assertionsSupport.importAssertion(source, overwrite2, createCopy, newName);
    }

    @Override
    public List<TestAssertion> getAssertionList() {
        return new ArrayList<TestAssertion>(this.assertionsSupport.getAssertionList());
    }

    @Override
    public WsdlMessageAssertion getAssertionByName(String name) {
        return this.assertionsSupport.getAssertionByName(name);
    }

    @Override
    public ModelItem getModelItem() {
        return this.testStep;
    }

    @Override
    public Map<String, TestAssertion> getAssertions() {
        return this.assertionsSupport.getAssertions();
    }

    @Override
    public String getDefaultAssertableContent() {
        return "";
    }

    @Override
    public String getResponseContentAsString() {
        return this.getResponse() == null ? null : this.getResponse().getContentAsString();
    }

    @Override
    public void setPath(String fullPath) {
        super.setPath(fullPath);
        if (this.getOperation() == null) {
            this.setEndpoint(fullPath);
        }
    }

    @Override
    public void setRestMethod(RestMethod restMethod) {
        RestMethod old = this.getRestMethod();
        if (old != null) {
            old.getResource().removePropertyChangeListener(this);
        }
        super.setRestMethod(restMethod);
        restMethod.getResource().addPropertyChangeListener(this);
        this.notifyPropertyChanged("restMethod", old, restMethod);
    }

    @Override
    public RestResource getResource() {
        return this.getRestMethod().getResource();
    }

    @Override
    public String getRestMethodName() {
        return this.getRestMethod().getName();
    }

    @Override
    public void resolve(ResolveContext<?> context) {
        super.resolve(context);
        this.assertionsSupport.resolve(context);
    }

    @Override
    public String getServiceName() {
        return this.testStep != null ? this.testStep.getService() : null;
    }

    @Override
    public boolean isDiscardResponse() {
        return this.getSettings().getBoolean("discardResponse");
    }

    public void setDiscardResponse(boolean discardResponse) {
        this.getSettings().setBoolean("discardResponse", discardResponse);
    }

    protected static class TestRequestIconAnimator
    extends AbstractHttpRequest.RequestIconAnimator<RestTestRequest> {
        public TestRequestIconAnimator(RestTestRequestInterface modelItem) {
            super((RestTestRequest)modelItem, "/rest_request.gif", "/exec_rest_request.gif", 4);
        }

        @Override
        public boolean beforeSubmit(Submit submit, SubmitContext context) {
            if (SoapUI.getTestMonitor() != null && (SoapUI.getTestMonitor().hasRunningLoadTest(((RestTestRequest)this.getTarget()).getTestCase()) || SoapUI.getTestMonitor().hasRunningSecurityTest(((RestTestRequest)this.getTarget()).getTestCase()))) {
                return true;
            }
            return super.beforeSubmit(submit, context);
        }

        @Override
        public void afterSubmit(Submit submit, SubmitContext context) {
            if (submit.getRequest() == this.getTarget()) {
                this.stop();
            }
        }
    }

    private class PropertyChangeNotifier {
        private Assertable.AssertionStatus oldStatus;
        private ImageIcon oldIcon;

        public PropertyChangeNotifier() {
            this.oldStatus = RestTestRequest.this.getAssertionStatus();
            this.oldIcon = RestTestRequest.this.getIcon();
        }

        public void notifyChange() {
            Assertable.AssertionStatus newStatus = RestTestRequest.this.getAssertionStatus();
            ImageIcon newIcon = RestTestRequest.this.getIcon();
            if (this.oldStatus != newStatus) {
                RestTestRequest.this.notifyPropertyChanged(HttpTestRequestInterface.STATUS_PROPERTY, (Object)this.oldStatus, (Object)newStatus);
            }
            if (this.oldIcon != newIcon) {
                RestTestRequest.this.notifyPropertyChanged(ModelItem.ICON_PROPERTY, this.oldIcon, RestTestRequest.this.getIcon());
            }
            this.oldStatus = newStatus;
            this.oldIcon = newIcon;
        }
    }
}

