/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.http;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.support.http.ProxyUtils;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.ProxySettings;
import com.eviware.soapui.support.StringUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCredentialsProvider
implements CredentialsProvider {
    private static final Logger logger = LoggerFactory.getLogger(HttpCredentialsProvider.class);
    private String requestUsername;
    private String requestPassword;
    private String requestDomain;
    private String requestAuthPolicy;
    private boolean checkedCredentials;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;

    public void setCredentials(AuthScope authScope, Credentials credentials) {
    }

    public Credentials getCredentials(AuthScope authScope) {
        if (authScope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        Credentials credentials = StringUtils.hasContent(this.proxyHost) && this.isProxyAuthScope(authScope) ? this.getProxyCredentials() : this.getRequestCredentials(authScope);
        return credentials;
    }

    public void clear() {
    }

    public void setRequestCredentials(String requestUsername, String requestPassword, String requestDomain, String requestAuthPolicy) {
        this.requestUsername = requestUsername;
        this.requestPassword = requestPassword == null ? "" : requestPassword;
        this.requestDomain = requestDomain;
        this.requestAuthPolicy = requestAuthPolicy;
    }

    public void setProxyCredentials(String proxyHost, String proxyPort, String proxyUsername, String proxyPassword) {
        this.setProxy(proxyHost, proxyPort);
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword == null ? "" : proxyPassword;
    }

    public void setProxy(String proxyHost, String proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public void loadProxyCredentialsFromSettings() {
        Settings settings = SoapUI.getSettings();
        boolean proxyEnabled = settings.getBoolean(ProxySettings.ENABLE_PROXY);
        boolean autoProxy = settings.getBoolean(ProxySettings.AUTO_PROXY);
        if (proxyEnabled) {
            String host = null;
            String port = null;
            if (!autoProxy) {
                host = PropertyExpander.expandProperties(settings.getString(ProxySettings.HOST, null));
                port = PropertyExpander.expandProperties(settings.getString(ProxySettings.PORT, null));
            }
            String username = PropertyExpander.expandProperties(settings.getString(ProxySettings.USERNAME, null));
            String password = PropertyExpander.expandProperties(settings.getString(ProxySettings.PASSWORD, null));
            this.setProxyCredentials(host, port, username, password);
        } else {
            this.setProxyCredentials(null, null, null, null);
        }
    }

    private boolean isProxyAuthScope(AuthScope authScope) {
        return this.proxyHost.equalsIgnoreCase(authScope.getHost()) && StringUtils.hasContent(this.proxyPort) && Integer.parseInt(this.proxyPort) == authScope.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Credentials getRequestCredentials(AuthScope authScope) {
        if (this.checkedCredentials) {
            return null;
        }
        if (this.requestAuthPolicy != null && !this.requestAuthPolicy.equalsIgnoreCase(authScope.getScheme())) {
            return null;
        }
        try {
            if ("NTLM".equalsIgnoreCase(authScope.getScheme())) {
                logger.debug("{}:{} requires Windows authentication", (Object)authScope.getHost(), (Object)authScope.getPort());
                NTCredentials nTCredentials = this.getNTCredentials(this.requestUsername, this.requestPassword, this.requestDomain);
                return nTCredentials;
            }
            if ("Basic".equalsIgnoreCase(authScope.getScheme()) || "Digest".equalsIgnoreCase(authScope.getScheme()) || "negotiate".equalsIgnoreCase(authScope.getScheme())) {
                logger.debug("{}:{} requires authentication with the realm '{}'", new Object[]{authScope.getHost(), authScope.getPort(), authScope.getRealm()});
                if (this.requestUsername == null && "Basic".equalsIgnoreCase(authScope.getScheme())) {
                    logger.warn("Username is empty");
                    UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials("", this.requestPassword);
                    return usernamePasswordCredentials;
                }
                UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(this.requestUsername, this.requestPassword);
                return usernamePasswordCredentials;
            }
        }
        finally {
            this.checkedCredentials = true;
        }
        return null;
    }

    private Credentials getProxyCredentials() {
        if (StringUtils.hasContent(this.proxyUsername) && StringUtils.hasContent(this.proxyPassword)) {
            return ProxyUtils.getProxyCredentials(this.proxyUsername, this.proxyPassword);
        }
        return null;
    }

    private NTCredentials getNTCredentials(String username, String password, String domain) {
        String workstation = "";
        try {
            workstation = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ignore) {
            // empty catch block
        }
        return new NTCredentials(username, password, workstation, domain);
    }
}

