/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.support.AnimatableItem;
import com.eviware.soapui.support.UISupport;
import java.util.concurrent.Future;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class IconAnimator<T extends AnimatableItem>
implements Runnable {
    private final T target;
    private int index = 0;
    private volatile boolean stopped = true;
    private boolean enabled = true;
    private ImageIcon baseIcon;
    private ImageIcon[] animateIcons;
    private volatile Future<?> future;

    public IconAnimator(T target, String iconName, String animationBaseIconName, int num) {
        this.baseIcon = UISupport.createImageIcon(iconName);
        this.target = target;
        this.createAnimatedIcons(animationBaseIconName, num);
    }

    private void createAnimatedIcons(String animationBaseIcon, int num) {
        String[] parts = animationBaseIcon.split("\\.", 2);
        String baseName = parts[0];
        String type = parts[1];
        this.animateIcons = new ImageIcon[num];
        for (int c = 0; c < this.animateIcons.length; ++c) {
            this.animateIcons[c] = UISupport.createImageIcon(baseName + "_" + (c + 1) + "." + type);
        }
    }

    public void stop() {
        this.stopped = true;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void start() {
        if (!this.enabled) {
            return;
        }
        if (!SoapUI.usingGraphicalEnvironment()) {
            return;
        }
        if (this.isStopped()) {
            Future<?> localFuture = this.future;
            if (this.future != null && !localFuture.isDone()) {
                localFuture.cancel(true);
                while (this.future != null) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.stopped = false;
            this.future = SoapUI.getThreadPool().submit(this);
        }
    }

    public ImageIcon getBaseIcon() {
        return this.baseIcon;
    }

    public ImageIcon getIcon() {
        if (!this.isStopped()) {
            return this.animateIcons[this.getIndex()];
        }
        return this.baseIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!SoapUI.usingGraphicalEnvironment()) {
            return;
        }
        String oldThreadName = Thread.currentThread().getName();
        if (this.future != null && System.getProperty("soapui.enablenamedthreads") != null) {
            Thread.currentThread().setName("IconAnimator for " + this.target.getName());
        }
        try {
            while (!this.stopped) {
                try {
                    if (this.stopped) break;
                    this.index = this.index >= this.animateIcons.length - 1 ? 0 : this.index + 1;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            IconAnimator.this.target.setIcon(IconAnimator.this.getIcon());
                        }
                    });
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    this.stopped = true;
                }
            }
            this.target.setIcon(this.getIcon());
            this.future = null;
            this.notify();
        }
        finally {
            if (System.getProperty("soapui.enablenamedthreads") != null) {
                Thread.currentThread().setName(oldThreadName);
            }
        }
    }

    public T getTarget() {
        return this.target;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!this.stopped) {
            this.stopped = enabled;
        }
    }
}

