/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.config.CredentialsConfig;
import com.eviware.soapui.impl.EmptyPanelBuilder;
import com.eviware.soapui.impl.wsdl.panels.teststeps.WsdlTestRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.support.components.JPropertiesTable;
import com.eviware.soapui.support.types.StringList;
import javax.swing.JPanel;

public class WsdlTestRequestPanelBuilder
extends EmptyPanelBuilder<WsdlTestRequestStep> {
    public WsdlTestRequestDesktopPanel buildDesktopPanel(WsdlTestRequestStep testStep) {
        return new WsdlTestRequestDesktopPanel(testStep);
    }

    @Override
    public boolean hasDesktopPanel() {
        return true;
    }

    public JPanel buildOverviewPanel(WsdlTestRequestStep testStep) {
        WsdlTestRequest request = testStep.getTestRequest();
        JPropertiesTable<WsdlTestRequest> table = new JPropertiesTable<WsdlTestRequest>("TestRequest Properties");
        table.addProperty("Name", "name", true);
        table.addProperty("Description", "description", true);
        table.addProperty("Message Size", "contentLength", false);
        table.addProperty("Encoding", "encoding", new String[]{null, "UTF-8", "iso-8859-1"});
        table.addProperty("Endpoint", "endpoint", request.getInterface() == null ? new String[]{} : request.getInterface().getEndpoints());
        table.addProperty("Timeout", "timeout", true);
        table.addProperty("Bind Address", "bindAddress", true);
        table.addProperty("Follow Redirects", "followRedirects", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Interface", "interfaceName");
        table.addProperty("Operation", "operationName");
        table.addProperty("Username", "username", true);
        table.addPropertyShadow("Password", "password", true);
        table.addProperty("Domain", "domain", true);
        table.addProperty("Authentication Type", "authType", new String[]{CredentialsConfig.AuthType.GLOBAL_HTTP_SETTINGS.toString(), CredentialsConfig.AuthType.PREEMPTIVE.toString(), CredentialsConfig.AuthType.SPNEGO_KERBEROS.toString(), CredentialsConfig.AuthType.NTLM.toString()});
        table.addProperty("WSS-Password Type", "wssPasswordType", new String[]{"None", "PasswordText", "PasswordDigest"});
        table.addProperty("WSS TimeToLive", "wssTimeToLive", true);
        StringList keystores = new StringList(request.getOperation().getInterface().getProject().getWssContainer().getCryptoNames());
        keystores.add(0, null);
        table.addProperty("SSL Keystore", "sslKeystore", keystores.toStringArray());
        table.addProperty("Skip SOAP Action", "skipSoapAction", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Enable MTOM", "mtomEnabled", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Force MTOM", "forceMtom", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Inline Response Attachments", "inlineResponseAttachments", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Expand MTOM Attachments", "expandMtomResponseAttachments", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Disable multiparts", "multipartEnabled", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Encode Attachments", "encodeAttachments", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Enable Inline Files", "inlineFilesEnabled", JPropertiesTable.BOOLEAN_OPTIONS).setDescription("Enables inline file references in elements with binary content; file:<path>");
        table.addProperty("Strip whitespaces", "stripWhitespaces", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Remove Empty Content", "removeEmptyContent", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Entitize Properties", "entitizeProperties", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Pretty Print", "prettyPrint", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Dump File", "dumpFile", true).setDescription("Dumps response message to specified file");
        table.addProperty("Max Size", "maxSize", true).setDescription("The maximum number of bytes to receive");
        table.addProperty("WS-Addressing", "wsAddressing", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Discard Response", "discardResponse", JPropertiesTable.BOOLEAN_OPTIONS);
        table.setPropertyObject(request);
        return table;
    }

    @Override
    public boolean hasOverviewPanel() {
        return true;
    }
}

