/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.testcase.actions;

import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.SimpleForm;
import com.jgoodies.forms.factories.ButtonBarFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class SetCredentialsAction
extends AbstractAction {
    private final WsdlTestCase testCase;
    private JDialog dialog;
    private SimpleForm form;
    private static final String DOMAIN = "Domain";
    private static final String PASSWORD = "Password";
    private static final String USERNAME = "Username";

    public SetCredentialsAction(WsdlTestCase testCase) {
        this.testCase = testCase;
        this.putValue("SmallIcon", UISupport.createImageIcon("/set_credentials.png"));
        this.putValue("ShortDescription", "Sets the credentials for all requests in this testcase");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.dialog == null) {
            this.buildDialog();
        }
        UISupport.showDialog(this.dialog);
    }

    private void buildDialog() {
        this.dialog = new JDialog(UISupport.getMainFrame(), "Set TestCase Credentials");
        this.form = new SimpleForm();
        this.form.appendTextField(USERNAME, "Username to use for authentication");
        this.form.appendPasswordField(PASSWORD, "Password to use for authentication");
        this.form.appendTextField(DOMAIN, "Domain to specify (for NTLM)");
        this.form.getPanel().setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.form.getPanel(), "Center");
        JPanel buttonBar = ButtonBarFactory.buildOKCancelBar((JButton)new JButton(new OkAction()), (JButton)new JButton(new CancelAction()));
        panel.add((Component)buttonBar, "South");
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setPreferredSize(new Dimension(270, (int)panel.getPreferredSize().getHeight()));
        this.dialog.getContentPane().add(panel);
        this.dialog.pack();
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SetCredentialsAction.this.dialog.setVisible(false);
        }
    }

    private class OkAction
    extends AbstractAction {
        public OkAction() {
            super("OK");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int c = 0; c < SetCredentialsAction.this.testCase.getTestStepCount(); ++c) {
                WsdlTestStep step = SetCredentialsAction.this.testCase.getTestStepAt(c);
                if (!(step instanceof WsdlTestRequestStep)) continue;
                WsdlTestRequestStep requestStep = (WsdlTestRequestStep)step;
                requestStep.getTestRequest().setUsername(SetCredentialsAction.this.form.getComponentValue(SetCredentialsAction.USERNAME));
                requestStep.getTestRequest().setPassword(SetCredentialsAction.this.form.getComponentValue(SetCredentialsAction.PASSWORD));
                requestStep.getTestRequest().setDomain(SetCredentialsAction.this.form.getComponentValue(SetCredentialsAction.DOMAIN));
            }
            SetCredentialsAction.this.dialog.setVisible(false);
        }
    }
}

